" Vim Syntax File
" Language:	    Dominions 3 Map
" Maintainer:	    analytic_kernel (http://forum.shrapnelgames.com/member.php?u=13499)
" Last Change:	    2009/01/24

if exists("b:current_syntax")
    finish
endif

syntax case match

setlocal iskeyword+=#

syntax match dom3NaturalPair /\d\+\_s\+\d\+/ display contained
syntax match dom3NatIntPair /\d\+\_s\+-\{0,1}\d\+/ display contained  
syntax match dom3NatStrPair /\d\+\_s\+"[^"]*"/ display contained
syntax match dom3NatEitherPair /\d\+\_s\+\(\d\+\|"[^"]*"\)/ display contained
syntax match dom3Natural /\d\+/ display contained
syntax match dom3Either /\(\d\+\|"[^"]*"\)/ display contained
syntax match dom3Integer /-\{0,1}\d\+/ display contained 
syntax match dom3Fixed1R1 /\d\.\d/ display contained
syntax match dom3Version /\d\.\d\{1,2}/ display contained 
syntax match dom3RGBTriplet /\(\d\.\d\_s\+\)\{2,2}\d\.\d/ display contained
syntax match dom3RGBAQuadruplet /\(\d\.\d\_s\+\)\{3,3}\d\.\d/ display contained
syntax region dom3String start=/"/ end=/"/ contained
syntax region dom3Comment start=/-/ end=/^\([^-]\|$\)/me=e-1 fold

highlight link dom3Natural			Number
highlight link dom3NaturalPair			Number
highlight link dom3Either			Identifier
highlight link dom3Integer			Number
highlight link dom3NatIntPair			Number
highlight link dom3Fixed1R1			Number
highlight link dom3Version			Number
highlight link dom3RGBTriplet			Number
highlight link dom3RGBAQuadruplet		Number
highlight link dom3String			String
highlight link dom3NatStrPair			Number
highlight link dom3NatEitherPair		Number
highlight link dom3Comment			Comment

