# -*- Mode: Python; tab-width: 4 -*-

import sys, random, re, shutil

class D3M:
    def __init__(self,
                 modname = "Unnamed",
                 description = "No description",
                 icon = "./dmg/tga/dmg.tga",
                 version = 0.1,
                 era = 1):

        self.modname = modname
        self.description = description
        self.icon = icon
        self.version = version
        self.era = era
        self.nation_slot = 72     # 0-94
        self.armor_slot = 200     # 200-399
        self.weapon_slot = 600    # 600-999
        self.site_slot = 750      # 750-999
        self.monster_slot = 2200  # 2200-2999
        self.tga_slot = 1         # 1-999
        
        self.eras = ["Early", "Middle", "Late"]
        self.nations = [[x for x in range(23)],
                        [x+27 for x in range(23)],
                        [x+49 for x in range(20)]]
        self.nations[0].remove(6)
        self.nations[0].append(26)
        self.nations[0].append(68)
        self.nations[1].append(69)
        self.nations[2].append(70)
        self.nations[2].append(71)
        self.magic_paths = ["Fire",
                            "Air",
                            "Water",
                            "Earth",
                            "Astral",
                            "Death",
                            "Nature",
                            "Blood"]
        self.modtext = ""
        self.modtext += "#modname \"" + self.modname + " " + self.eras[self.era-1] + " Age\"\n"
        self.modtext += "#description \"" + self.description + "\"\n"
        if self.icon:
            self.modtext += "#icon \"" + self.icon + "\"\n"
        self.modtext += "#version " + str(self.version) + "\n"
        self.modtext += "\n"

    def add_custom(self, custom):
        self.modtext += custom

    def add_monster(self, text):
        self.modtext += "\n#newmonster " + str(self.monster_slot) + "\n"
        self.modtext += text + "\n#end\n"
        self.monster_slot +=1

    def add_nation(self, D3Mnation):
        D3Mnation.era = self.era
        D3Mnation.slot = self.nation_slot
        self.modtext += str(D3Mnation)
        self.nation_slot += 1
        return (self.nation_slot -1)
    
    def remove_default_nations(self, exceptions = None):
        era = 3
        if self.era == 3:
            era = 1

        if exceptions:
            if not isinstance(exceptions, list):
                exceptions = [exceptions,]
                
        for nation in self.nations[self.era-1]:
            if exceptions and not nation in exceptions:
                self.modtext += "\n#selectnation " + str(nation) + "\n"
                self.modtext += "#era " + str(era) + "\n"
                self.modtext += "#end\n"
            

    def add_all_nations(self):
        for era in range(3):
            for nation in self.nations[era]:
                self.modtext += "\n#selectnation " + str(nation) + "\n"
                self.modtext += "#era " + str(self.era) + "\n"
                self.modtext += "#end\n"
            

    def add_site(self, D3MSite):
        D3MSite.slot = self.site_slot
        self.modtext += str(D3MSite)
        self.site_slot += 1
        return (self.site_slot-1)

    def _replace(self, match):
        text = match.group(0)
        target = re.compile(' \d+')
        if re.search('dmged',text):
            return text
        repl = " " + str(self.monster_slot) + " dmged "
        text = re.sub(target, repl, text)
        return text

    def add_dm(self, text, isanation = True):
        linebreaks = re.compile('[\t\n\r\f\v]')
        header = re.compile('\#(modname|domversion|description|icon|version)')
        text = re.sub(header, " ", text)

        newmonster = re.compile('\#newmonster.*?(\d+)')
        for monster in re.finditer(newmonster, text):
            regex_targets = ['newmonster', 'addrec', 'home', 'hero', 'def', 'start', 'damage',
                             'makemonster', 'summon', 'shape']
            for item in regex_targets:
                target = re.compile("\#.*?" + item + ".*?" + monster.group(1) +".*")
                text = re.sub(target, self._replace, text)
            self.monster_slot += 1

        newsite = re.compile('(\#newsite.*?\d+)')
        for site in re.finditer(newsite, text):
            target = re.compile(site.group(1))
            replace = "#newsite " + str(self.site_slot) + " dmged "
            text = re.sub(target, replace, text)
            self.site_slot += 1

        newarmor = re.compile('(\#newarmor.*?)(\d+)')
        for armor in re.finditer(newarmor, text):
            target = re.compile(armor.group(1)+armor.group(2))
            replace = "#newarmor " + str(self.armor_slot) + " dmged "
            text = re.sub(target, replace, text)
            target = re.compile("\#armor.*?"+str(armor.group(2)))
            replace = "#armor " + str(self.armor_slot) + " dmged "
            text = re.sub(target, replace, text)
            self.armor_slot += 1

        newweapon = re.compile('(\#newweapon.*?)(\d+)')
        for weapon in re.finditer(newweapon, text):
            target = re.compile(weapon.group(1)+weapon.group(2))
            replace = "#newweapon " + str(self.weapon_slot) + " dmged "
            text = re.sub(target, replace, text)
            target = re.compile("\#weapon.*?"+str(weapon.group(2)))
            replace = "#weapon " + str(self.weapon_slot) + " dmged "
            text = re.sub(target, replace, text)
            self.weapon_slot += 1

        restricted = re.compile('(\#restricted\s*?\d+)')
        for item in re.finditer(restricted, text):
            target = re.compile(item.group(1))
            replace = "#restricted " + str(self.nation_slot) + " dmged "
            text = re.sub(target, replace, text)

        restrictedgod = re.compile('(\#restrictedgod\s*?\d+)')
        for item in re.finditer(restrictedgod, text):
            target = re.compile(item.group(1))
            replace = "#restrictedgod " + str(self.nation_slot) + " dmged "
            text = re.sub(target, replace, text)

        if isanation:
            nation = re.compile('(\#selectnation.*?\d+)')
            found = re.search(nation, text)
            if found:
                target = re.compile(found.group(1))
                replace = "#selectnation " + str(self.nation_slot) + " dmged "
                text = re.sub(target, replace, text)
                self.nation_slot += 1

        era = re.compile('(\#era.*?\d+)')
        found = re.search(era, text)
        if found:
            target = re.compile(found.group(1))
            replace = "#era " + str(self.era) + " dmged "
            text = re.sub(target, replace, text)

        tga = re.compile('\"(.*?tga)\"')
        for graphic in re.finditer(tga, text):
            pic = graphic.group(1)
            name = "./dmg/tga/dmgtga"+str(self.tga_slot)+".tga"

            try:
                shutil.copy(pic,name)
            except:
                self.modtext += "Bad File Name: " +pic
                
            target = re.compile(pic)
            text = re.sub(target, name, text)
            self.tga_slot += 1

        self.modtext += text

    def __str__(self):
        self.modtext += "\nDomModGen"
        self.modtext += "\nNations: " +str(self.nation_slot-72)
        self.modtext += "\nMonsters: " +str(self.monster_slot-2200)
        self.modtext += "\nMagic Sites: " +str(self.site_slot-750)
        self.modtext += "\nWeapons: " +str(self.weapon_slot-600)
        self.modtext += "\nArmor: " +str(self.armor_slot-200)
        self.modtext += "\nTGAs: " +str(self.tga_slot-1)
        return self.modtext

class D3MSite:
    def __init__(self, name = "No name"):

        self.slot = None
        self.name = name
        self.units = []
        self.commanders = []
        self.gems = []
        self.gold = 0
        self.resources = 0

    def add_commanders(self, commanders):
        if isinstance(commanders, list):
            for commander in commanders:
                self.commanders.append(commander)
        else:
            self.commanders.append(commanders)

    def add_units(self, units):
        if isinstance(units, list):
            for unit in units:
                self.units.append(unit)
        else:
            self.units.append(units)
        
    def add_gems(self, path, number):
        self.gems.append((path, number))
        
    def add_gold(self, amount):
        self.gold = amount

    def add_resources(self, amount):
        self.resources = amount

    def _unique_list(self, items):
        new_list = []
        for item in items:
            if item not in new_list:
                new_list.append(item)
        return new_list
        
    def __str__(self):
        output = ""
        output += "#newsite " + str(self.slot) + "\n"
        output += "#name \"" + self.name + "\"\n"
        if self.gems:
            self.gems = self._unique_list(self.gems)
            for gem in self.gems:
                output += "#gems " + str(gem[0]) + " " + str(gem[1]) + "\n"
        if self.commanders:
            self.commanders = self._unique_list(self.commanders)
            for commander in self.commanders:
                output += "#homecom " + str(commander) + "\n"
        if self.units:
            self.units = self._unique_list(self.units)
            for unit in self.units:
                output += "#homemon " + str(unit) + "\n"
        if self.gold != 0:
            output += "#gold " + str(self.gold) + "\n"
        if self.resources != 0:
            output += "#resources " + str(self.resources) + "\n"

        output += "\n#end\n"

        return output

    
class D3MNation:
    def __init__(self, era,
                 name = "Unnamed",
                 epithet = "No epithet",
                 brief = "No brief",
                 description = "No description",
                 summary = "No summary",
                 flag = None):

        self.era = era
        self.slot = None
        self.name = name
        self.brief = brief
        self.epithet = epithet
        self.description = description
        self.summary = summary
        self.flag = flag
        self.sites = []
        self.commanders = []
        self.units = []
        self.heros = []
        self.multiheros = []
        self.defcom1 = 44
        self.defcom2 = 240
        self.defunit1 = 29
        self.defunit1b = 17
        self.defunit2 = 34
        self.defmult1 = None
        self.defmult1b = None
        self.castleprod = 0
        self.startfort = 3
        self.defaultfort = 8
        self.farmfort = 3
        self.forestfort = 33
        self.mountainfort = 36
        self.swampfort = 10
        self.startcom = 44
        self.startscout = 426
        self.startunittype1 = 38
        self.startunitnbrs1 = 20
        self.startunittype2 = 17
        self.startunitnbrs2 = 20
        self.nationals = []
        
    def add_commanders(self, commanders):
        if isinstance(commanders, list):
            for commander in commanders:
                self.commanders.append(commander)
        else:
            self.commanders.append(commanders)

    def add_pretenders(self, mod, pretenders):
        nation = mod.nation_slot
        p_list = []
        if isinstance(pretenders, list):
            for pretender in pretenders:
                p_list.append(pretender)
        else:
            p_list.append(pretenders)

        for pretender in p_list:
            dm_text = "#copystats " + str(pretender)
            dm_text += "\n#copyspr " + str(pretender) 
            dm_text += "\n#restrictedgod " + str(nation) 
            mod.add_monster(dm_text)

    def add_units(self, units):
        if isinstance(units, list):
            for unit in units:
                self.units.append(unit)
        else:
            self.units.append(units)
        
    def add_heros(self, heros):
        if isinstance(heros, list):
            for unit in heros:
                self.heros.append(unit)
        else:
            self.heros.append(heros)
        
    def add_multiheros(self, multiheros):
        if isinstance(multiheros, list):
            for unit in multiheros:
                self.multiheros.append(unit)
        else:
            self.multiheros.append(multiheros)
        
    def add_site(self, site_name):
        self.sites.append(site_name)

    def set_PD(self, defcom1, defcom2, defunit1, defunit1b, defunit2, defmult1 = None, defmult1b = None):

        self.defcom1 = defcom1
        self.defcom2 = defcom2
        self.defunit1 = defunit1
        self.defunit1b = defunit1b
        self.defunit2 = defunit2
        self.defmult1 = defmult1
        self.defmult1b = defmult1b

    def set_forts(self, castleprod, startfort, defaultfort, farmfort,
                  forestfort, mountainfort, swampfort):

        self.castleprod = castleprod
        self.startfort = startfort
        self.defaultfort = defaultfort
        self.farmfort = farmfort
        self.forestfort = forestfort
        self.mountainfort = mountainfort
        self.swampfort = swampfort
    

    def set_startarmy(self, startcom, startscout, startunittype1,
                      startunitnbrs1, startunittype2, startunitnbrs2):

        self.startcom = startcom
        self.startscout = startscout
        self.startunittype1 = startunittype1
        self.startunitnbrs1 = startunitnbrs1
        self.startunittype2 = startunittype2
        self.startunitnbrs2 = startunitnbrs2

    def copy_national(self, spell, new_name = None,  new_desc = None):
        self.nationals.append((spell, new_name, new_desc))
       
    def _unique_list(self, items):
        new_list = []
        for item in items:
            if item not in new_list:
                new_list.append(item)
        return new_list
        
    def __str__(self):

        output = "***************************\n"
        output += "#selectnation " + str(self.slot) + "\n"
        output += "#name \"" + self.name + "\"\n"
        output += "#epithet \"" + self.epithet + "\"\n"
        output += "#era " + str(self.era) + "\n"
        output += "#clearnation\n"
        output += "#clearrec\n"
        output += "#clearsites\n"
        output += "\n"
        output += "#brief \"" +self.brief + "\"\n"
        output += "#descr \"" +self.description + "\"\n"
        output += "#summary \"" +self.summary + "\"\n"
        if self.flag:
            output += "#flag \"" +self.flag + "\"\n"

        output += "\n"
        for site in self.sites:
            output += "#startsite \"" + site + "\"\n"
        output += "\n"
        if self.commanders:
            self.commanders = self._unique_list(self.commanders)
            for commander in self.commanders:
                output += "#addreccom " + str(commander) + "\n"
        if self.units:
            self.units = self._unique_list(self.units)
            for unit in self.units:
                output += "#addrecunit " + str(unit) + "\n"
        output += "\n"
        output += "#defcom1 " + str(self.defcom1) + "\n"
        output += "#defcom2 " + str(self.defcom2) + "\n"
        output += "#defunit1 " + str(self.defunit1) + "\n"
        output += "#defunit1b " + str(self.defunit1b) + "\n"
        output += "#defunit2 " + str(self.defunit2) + "\n"
        if self.defmult1:
            output += "#defmult1 " + str(self.defmult1) + "\n"
        if self.defmult1b:
            output += "#defmult1b " + str(self.defmult1b) + "\n"

        output += "\n"
        output += "#castleprod " + str(self.castleprod) + "\n"
        output += "#startfort " + str(self.startfort) + "\n"
        output += "#defaultfort " + str(self.defaultfort) + "\n"
        output += "#farmfort " + str(self.farmfort) + "\n"
        output += "#forestfort " + str(self.forestfort) + "\n"
        output += "#swampfort " + str(self.swampfort) + "\n"
        output += "#mountainfort " + str(self.mountainfort) + "\n"
        output += "\n"
        output += "#startcom " + str(self.startcom) + "\n"
        output += "#startscout " + str(self.startscout) + "\n"
        output += "#startunittype1 " + str(self.startunittype1) + "\n"
        output += "#startunitnbrs1 " + str(self.startunitnbrs1) + "\n"
        output += "#startunittype2 " + str(self.startunittype2) + "\n"
        output += "#startunitnbrs2 " + str(self.startunitnbrs2) + "\n"

        counter = 1
        for unit in self.heros:
            output += "\n#hero"+str(counter)+" " + str(unit) + "\n"
            counter += 1
            
        counter = 1
        for unit in self.multiheros:
            output += "\n#multihero"+str(counter)+" " + str(unit) + "\n"
            counter += 1
            
        output += "\n"
        output += "#end\n"

        for spell, name, desc in self.nationals:
            output += "\n#newspell\n#copyspell \"" + spell + "\"\n"
            if name:
                output += "#name \"" + name + "\"\n"
            if desc:
                output += "#descr \"" + desc + "\"\n"
                
            output += "#restricted " + str(self.slot) + "\n"
            output += "#end\n"

        output += "\n"
        return output

