#!/usr/bin/env python
# -*- Mode: Python; tab-width: 4 -*-

import sys, random
from DMG import D3MNation, D3MSite

name = "independents"

def pop_random(list):
    return list.pop(random.randrange(len(list)))
        
def get_epithet():
    choice1 = ["Beaten", "Sore", "Bleeding", "Wounded", "Maimed", "Hurt", "Blessed"]
    choice2 = ["Angry", "Vengeful", "Grumpy", "Furious", "Cross", "Pissed", "Joyful"]
    return pop_random(choice1) + " and " + pop_random(choice2)

def create_nation(mod, name, flag = None):
    description = "Vanquished and exiled from their homeland by invading Pretender Gods, "
    description += "the " + name + " have settled here and are determined to survive."
        
    epithet = get_epithet()
    summary = "None"
    brief = "None"
    
    II_AI = D3MNation(None, name, epithet, brief, description, summary, flag)
    FunPitPower = D3MSite(name + " Power")

    base_recruitables = [55, #longbow
                         40, #HI
                         24,26,
                         21,
                         47,
                         518,447,234,365,
                         
                         ]
    II_AI.add_units(base_recruitables)


    base_commanders = [426,  # scout
                       36,
                       241,  # priest
                       630,99,101,477,100,122,95,875,
                       ]
    II_AI.add_commanders(base_commanders)

    # Features

    II_AI.set_PD(875,100,40,55,21,1.5,2)

    for path in range(8):
        FunPitPower.add_gems(path,1)
            
    II_AI.add_site(FunPitPower.name)
    II_AI.set_forts(castleprod = 50,
                    startfort = 3,
                    defaultfort = 8,
                    farmfort = 3,
                    forestfort = 29,
                    mountainfort = 9,
                    swampfort = 5)

    II_AI.set_startarmy(875, 426, 40, 20, 55, 20)

    mod.add_nation(II_AI)
    mod.add_site(FunPitPower)

    return "Added nation "+str(II_AI.slot)+" "+II_AI.name+"\n"
