#modname "Harabatia: The United Raptors"
#description "The Raptor clans initially scattered to the corners of the earth after their banishment from Caelum.  Now they have found a new God who promises to lead them to victory over the other clans and the world."
#version 1.03
#icon "./Harabatia/banner.tga"

--change log for 1.03
--description fixes
--added Wingless Cloudgazer commander 2S, very expensive, no leadership (but provides access to astral that is pivotal for late game strat of eagle kings)
--made trolls capitol only
--created new start site, "City of the Trolls"
--removed research bonus for eagle king god form
--gave troll units forest survival
--renumbered units/start sites to remove between mod conflicts with Haida Gwaii and Mytheology
--reduced cost of Holy Father to 1 gem
--reduced and reworked magic skills for Master Harab, now 3A2E2S3D, also reduced leadership from expert to good and set max age to 75, removing older command and setting starting age
--made Great Seraphine a hero instead of multihero
--added Raptor Axe Warrior
--fixed an error in the description of the Arch Harab caused by a missing quotation mark.
--change log for 1.02
--added Arch Harab God chassis
--reduced magic skill and increased cost for additional paths for Eagle King god form.
--removed raptor elephant riders from recruitable set, now a level 2 conjuration summon costing 4 nature gems.
--fixed encumbrance for risen troll king, now set at 0
--made Harab Elders capitol only
--started documenting changes
--altered graphics of Harab Naturalist and Harab Sage to be less lurid, added browns and blacks to robes
--reduced morale for Raptor Militia to 9, and for Raptor Homeguard to 10.
--added Raptor Hunter unit
--reordered recruitable line-up
--change log for 1.01
--reduced damage and attach values for shield smash
--increased defense penalty and encumbrance of Troll Shield and Elephant Leather Hauberk
--increased gold cost of Harab Troll and Elite Troll
--reduced hit points and precision of Wingless Archers
--reduced hit points of Wingless Raven
--replaced reinvigoration with regeneration for Risen Troll King
--increased gem cost of Summon Eagle King, To Dust and From Dust, and Knowledge of the Ancestors

--weapon slots: 700 - 702
--armor slots 245 - 247
--unit slots: 2400 - 2432
--site slots 801 - 803
--adds 8 spells
--uses nation slot 72
#newweapon 700
#name "Shield Smash"
#dmg -4
#nratt 1
#att -3
#def -2
#len 2
#rcost 0
#sound 10
#bonus
#charge
#end

#newweapon 701
#name "Troll Axe"
#dmg 6
#nratt 1
#att 0
#def -2
#len 3
#rcost 2
#sound 10
#enc 4
#end

#newweapon 702
#name "Troll Flail"
#dmg 4
#nratt 2
#att 1
#def -3
#len 4
#rcost 4
#sound 10
#flail
#enc 4
#end

#newarmor 245
#name "Advanced Fireplate"
#prot 19
#def -2
#enc 3
#rcost 18
#type 5
#end

#newarmor 246
#name "Elephant Leather Hauberk"
#type 5
#prot 9
#def -1
#enc 1
#rcost 4
#end

#newarmor 247
#name "Troll Shield"
#type 4
#prot 13
#def 5
#enc 3
#rcost 7
#end

--Units--

#newmonster 2400
#spr1 "./Harabatia/Wingless Archer 1.tga"
#spr2 "./Harabatia/Wingless Archer 2.tga"
#name "Wingless Archer"
#descr "The Raptors have never deigned to wield bows.  When the clans were united, the Spire Horn and High Caelians would serve in the archer corps, for the Raptors, that role is held by the wingless."
#hp 10
#str 11
#mor 11
#mr 11
#enc 1
#att 10
#def 10
#prec 11
#mapmove 2
#ap 10
#size 2
#gcost 12
#rcost 1
#weapon 24
#weapon 9
#armor "Full Leather Armor"
#armor "Reinforced Leather Cap"
#mountainsurvival
#forestsurvival
#nametype 111
#maxage 75
#end

#newmonster 2401
#spr1 "./Harabatia/Wingless Raven 1.tga"
#spr2 "./Harabatia/Wingless Raven 2.tga"
#name "Wingless Raven"
#descr "The High Caelians weren't the only ones to be afflicted with the curse of the wingless, recently some raptors have also been born with the affliction.  The Harab Trolls recognized the usefulness of having soldiers that can fight in formation and weild larger pikes and bows.  The Raptors have since turned over all of their wingless to the trolls for martial training, and they have formed a thriving community among them.  These particular wingless are armed with long spears and large shields and make up a capable front line called the Wingless Ravens.  Though their attrition rates are high, they nonetheless fight with great skill and pride." 
#hp 11
#str 11
#mor 12
#mr 12
#enc 1
#att 12
#def 11
#prec 10
#mapmove 2
#ap 10
#size 2
#gcost 15
#rcost 1
#weapon 28
#weapon 21
#armor "Chain Mail Cuirass"
#armor "Kite Shield"
#armor "Half Helmet"
#mountainsurvival
#forestsurvival
#nametype 111
#maxage 75
#end

#newmonster 2402
#name "Harab Troll"
#descr "When the Raptors arrived at what would one day be called Mount Raptor, it was already inhabited by a powerful group of trolls.  Knowing that his tired and ill-equipped people could not survive a war with the trolls, Gerasha instead challenged their king to single combat, and won, claiming the right of kingship to himself.  Over time the trolls and Raptors learned to coexist peacefully.  The trolls have slowly altered their traditional tactics to conform to the Raptor war machine.  Instead of wielding clubs and wearing furs, they have taken up large axes, and armor themselves with leather and shields.  They survive on a diet of sticks and stones, and can see in the dark better than most. Trolls regenerate, but are susceptible to fire."
#spr1 "./Harabatia/Harab Troll 1.tga"
#spr2 "./Harabatia/Harab Troll 2.tga"
#hp 35
#prot 11
#mor 12
#mr 14
#enc 2
#str 22
#att 10
#def 9
#prec 8
#mapmove 2
#ap 16
#noleader
#startage 77
#maxage 400
#fireres -25
#darkvision 50
#neednoteat
#regeneration 10
#mountainsurvival
#forestsurvival
#weapon 701
#weapon 700
#armor "Troll Shield"
#armor "Elephant Leather Hauberk"
#gcost 70
#rcost 2
#size 3
#end

#newmonster 2403
#copystats 1037
#spr1 "./Harabatia/Elite Troll 1.tga"
#spr2 "./Harabatia/Elite Troll 2.tga"
#name "Elite Troll"
#descr "When the Raptors arrived at what would one day be called Mount Raptor, it was already inhabited by a powerful group of trolls.  Knowing that his tired and ill-equipped people could not survive a war with the trolls, Gerasha instead challenged their king to single combat, and won, claiming the right of kingship to himself.  Over time the trolls and Raptors learned to coexist peacefully.  The trolls have slowly altered their traditional tactics to conform to the Raptor war machine.  These elite trolls are armored in heavy plate, and wield large flails as well as the spiked shields they use to smash into opponents on the charge.  They survive on a diet of sticks and stones, and can see in the dark better than most. Trolls regenerate, but are susceptible to fire."
#att 11
#def 11
#ap 16
#weapon 702
#weapon 700
#gcost 90
#armor "Troll Shield"
#armor "Full Plate Mail"
#forestsurvival
#end

#newmonster 2404 --Raptor Militia--
#copystats 205
#copyspr 205
#name "Raptor Militia"
#descr "Poorly armed and armored, these conscripts are best recruited only in times of dire need."
#maxage 75
#mor 9
#end

#newmonster 2405
#copystats 205
#spr1 "./Harabatia/RaptorHomeGuard.tga"
#spr2 "./Harabatia/RaptorHomeGuard2.tga"
#name "Raptor Home Guard"
#descr "The Raptor Home Guard was created as a well armed militia, and that is really all they are, poorly trained and armed, they are little better than the quickly levied peasant raptors, but the addition of a shield and javalins can make all the difference in maintaining a strong line."
#mor 10
#weapon 1
#weapon 21
#armor "Leather Hauberk"
#armor "Shield"
#maxage 75
#end

#newmonster 2406 --Raptorian Warrior--
#copystats 1278
#copyspr 1278
#armor "Half Helmet"
#armor "Ring Mail Hauberk"
#armor "Shield"
#maxage 75
#end

#newmonster 2407 --Iron Crow--
#copystats 1279
#copyspr 1279
#weapon 8
#armor "Half Helmet"
#armor "Plate Cuirass"
#armor "Kite Shield"
#rcost 1
#ressize 2
#maxage 75
#end

#newmonster 2408 --Raven Guard--
#copystats 949
#copyspr 949
#clearspec
#flying
#weapon 8
#weapon 6
#armor "Plate Cuirass"
#armor "Half Helmet"
#ambidextrous 2
#rcost 1
#ressize 2
#maxage 75
#end

#newmonster 2409
#spr1 "./Harabatia/Risen Yazad.tga"
#spr2 "./Harabatia/Risen Yazad 2.tga"
#name "Risen Yazad"
#descr "At the end of the Great Exile Gerasha found himself in command of a people beleugered by trials and strengthened by hardship.  This culling of the weak has removed many of the less pure elements of Raptor lineage, and unusual orange winged individuals resembling the ancient Yazatas that birthed the Caelians have been born from time to time.  Recognizing the possibility for greatness in these exceptional individuals, the Seraphines have ordered them to breed solely amongst themselves, and to take up arms as an elite fighting force sacred to the Caelian people, armed with golden spears and exceptionally constructed armor.  They have become known as the Risen Yazatas."
#hp 14
#str 12
#mor 14
#mr 12
#enc 1
#att 12
#def 12
#prec 12
#mapmove 3
#ap 15
#size 3
#holy
#flying
#weapon 473
#armor "Advanced Fireplate"
#armor "Shield"
#armor "Half Helmet"
#gcost 45
#rcost 5
#nametype 111
#ressize 2
#maxage 75
#end

#newmonster 2410
#spr1 "./Harabatia/Raptor Hunter.tga"
#spr2 "./Harabatia/Raptor Hunter 2.tga"
#name "Raptor Hunter"
#descr "No winged Raptor soldier would be caught dead wielding a bow.  It was this cultural attitude that led to the formation of the Wingless Archer corps, however, the common folk feel no such stigma.  In fact there is a long tradition of hunting from the skies with short bows, first developed during the Great Exile in order to supply the clan with food.  On occassion these poorly trained archers have been pressed into military service for short periods."
#hp 9
#prot 0
#mor 8
#mr 10
#enc 4
#str 10
#att 8
#def 8
#prec 8
#mapmove 3
#ap 9
#nametype 111
#maxage 75
#size 3
#resize 2
#weapon 23
#weapon 9
#armor "Leather Hauberk"
#gcost 8
#rcost 1
#flying
#end

#newmonster 2431
#spr1 "./Harabatia/Raptor Axe Warrior 1.tga"
#spr2 "./Harabatia/Raptor Axe Warrior 2.tga"
#copystats 1278
#name "Raptor Axe Warrior"
#descr "The greater comparative strength of the raptors to the other Caelian clans enables them to wield other weapons besides the traditional spears, bows, and small swords.  Particularly it allows them to wield weapons that rely on strength rather than speed or length.  The Raptor Axe Warrior corps demonstrate this difference effectively."
#weapon 17
#armor "Half Helmet"
#armor "Ring Mail Hauberk"
#armor "Shield"
#end
--Commanders--

#newmonster 2411
#copystats 1707
#spr1 "./Harabatia/Raptor Scout 1.tga"
#spr2 "./Harabatia/Raptor Scout 2.tga"
#name "Raptor Scout"
#descr "The ability to fly is the difference between a good scout, and an incredible scout, able to bypass enemy forces, travel long distances, and avoid obstacles, Raptor scouts are a formidable tool, and since the Raptors value knowledge of the land and air highly, the scouts of Harabatia are well trained."
#clearspec
#flying
#stealthy 10
#noleader
#nametype 111
#ressize 2
#maxage 75
#end

#newmonster 2412
#copystats 1279
#spr1 "./Harabatia/Crow Lord 1.tga"
#spr2 "./Harabatia/Crow Lord 2.tga"
#name "Crow Lord"
#descr "The best of the iron crows are given further training, and become the leaders of the raptorian armies, the Crow Lords"
#hp 13
#att 13
#goodleader
#nametype 111
#weapon 8
#armor "Plate Cuirass"
#armor "Half Helmet"
#armor "Kite Shield"
#ressize 2
#maxage 75
#gcost 60
#end

#newmonster 2413
#copystats 1282
#copyspr 204
#name "Young Seraphine"
#descr "The Young Seraphines who have not yet received any magical training are responsible for the far flung parts of the growing empire.  They constantly covet positions in the capitol, and their priestly authority is limited, but they are plentiful. Young Seraphines are untrained and ill-suited to leading armies."
#clearmagic
#magicskill 8 1
#gcost 70
#rcost 1
#noleader
#maxage 75
#end

#newmonster 2414 --Caretaker--
#copystats 1282
#copyspr 1282
#descr "Though for the most part males are not allowed into the priestly orders of Harabatia, occasionally a candidate for the magocracy will be accepted into priestly training as a caretaker.  The caretakers are charged with maintaining the cemetaries, and are forbidden to lead armies or associate with their old order after acceptance.  They use some limited earth and death magic in their work, and serve as decent priest mages in a pinch."
#noleader
#maxage 75
#end

#newmonster 2415 --Harab Seraph--
#copystats 951
#copyspr 951
#descr "The Seraphs of Harabatia, like those of Caelum, are the undisputed rulers of their people.  The Seraphs are skilled in air and death magic, and some receive training in earth and nature magic as well.  There are also various specializations among the Harab Seraphs, such as the Iron Crafters, who build magical items and armor, the Naturalists, who travel to the distant farms and forests to aid in the supply of the people, and the sages, who seek knowledge of spellcasting new and old."
#clearmagic
#magicskill 1 1
#magicskill 5 1
#custommagic 13568 100
#weapon 9
#armor "Leather Cap"
#ressize 2
#maxage 75
#end

#newmonster 2416 --Iron Crafter--
#copystats 1281
#copyspr 1281
#descr "After Leaving Caelum, the Raptors discovered that they had much more need for iron than for ice, and so the skills of the ice crafters have been realligned to the forging of iron.  Iron Crafters are earth mages that specialize in magical forging, and use less gems when forging items."
#clearmagic
#magicskill 3 2
#ressize 2
#maxage 75
#gcost 120
#end

#newmonster 2417
#copystats 951
#spr1 "./Harabatia/Naturalist.tga"
#spr2 "./Harabatia/Naturalist 2.tga"
#name "Harab Naturalist"
#descr "While most of the Harab Seraphs pursue a mix of magical schools, the Harab Naturalists pursue only Nature magic, they often go about the provinces working to improve the lot of Harabatia's farmers."
#clearmagic
#magicskill 6 2
#weapon 9
#armor "Leather Cap"
#supplybonus 25
#ressize 2
#maxage 75
#gcost 120
#end

#newmonster 2418
#name "Harab Sage"
#descr "A Harab Seraph dedicated to the study of ancient writings and the nature of magic, the Harab Sages are incapable of leading armies, and have little practical magical skill, however they are very skilled in magical research.  The Harab Sages are marked by the purple robes of their order."
#spr1 "./Harabatia/Harab Sage 1.tga"
#spr2 "./Harabatia/Harab Sage 2.tga"
#gcost 150
#rcost 1
#hp 9
#prot 0
#mor 12
#mr 14
#enc 4
#str 9
#att 8
#def 7
#prec 12
#mapmove 3
#ap 8
#noleader
#flying
#clearmagic
#magicskill 5 1
#researchbonus 4
#weapon 9
#armor "Leather Cap"
#maxage 75
#end

#newmonster 2419 --Harab Elder--
#copystats 1003
#copyspr 1003
#clearmagic
#descr "After the Caelian civil war, many of the raptors blaimed the Harab order for their troubles, however, there was no other source of strong leadership among the people.  Afraid that the Raptor clan would scatter to the corners of the earth without strong leadership, the last Harab Elder proposed a compromise, the Harab mages would give up priestly authority, as well as command of the army, but would retain control as the rulers of the clan.  Furthermore, with so few remaining skilled Seraphs, many teachings and magics were lost, including the use of water magic.  However, when the wandering Harab nation arrived at the forests of Pangaea, the Harab Elders sought new knowledge of nature and her ways among the pans."
#magicskill 1 2
#magicskill 3 1
#magicskill 5 2
#magicskill 6 1
#custommagic 13568 100
#custommagic 13568 50
#goodleader
#gcost 320
#ressize 2
#maxage 75
#weapon 9
#older 10
#end

#newmonster 2420
#copystats 1003
#copyspr 557
#name "Harab Seraphine"
#descr "The Harab have always had a tradition of ancestor worship, and after the Caelian civil war and the abandonment of the Raptor clans by the old Pantokrator, it became their sole religion.  Like in Caelum of old, only females serve in the role of priests for the ancestor cult, females born with the white wings of ghosts, a tradition started to ensure that the male mages of the Harab order would not be priests.  However, that has not stopped the Harab Elders from teaching the Seraphines of particular skill some elementary magic.  These women particularly show an aptitude for death and nature magic."
#clearmagic
#magicskill 6 1
#magicskill 5 1
#magicskill 8 2
#gcost 170
#holy
#nametype 111
#ressize 2
#maxage 75
#female
#okleader
#weapon 7
#armor "Leather Cap"
#maxage 75
#end

#newmonster 2432
#spr1 "./Harabatia/Wingless Stargazer.tga"
#spr2 "./Harabatia/Wingless Stargazer 2.tga"
#name "Wingless Cloudgazer"
#descr "While nominally the wingless follow the cult of ancestor worship, many of them feel abandoned by the ancestors, and have dedicated themselves to the search for the original lords of Caelum, hoping that they will restore their wings and exalt them.  These 'cloudgazers' as they call themselves are skilled in astral magic. However, they are resentful of the new God, and will only work for an exorbitant price."
#gcost 350
#rcost 1
#hp 9
#prot 0
#mor 12
#mr 14
#enc 4
#str 9
#att 8
#def 7
#prec 12
#mapmove 2
#ap 8
#noleader
#clearmagic
#magicskill 4 2
#weapon 92
#maxage 75
#size 2
#end

--Heroes--

#newmonster 2421
#copystats 1003
#copyspr 1003
#clearmagic
#name "Master Harab"
#nametype 0
#descr "The current leader of the Harab Seraphs, and also the most skilled.  As such he is the nominal leader of Harabatia.  While technically the Seraphs are not supposed to lead armies, the Master Harab was able to convince the new God that allowing them to stand in for military commanders in times of need would be beneficial to the kingdom.  The Master Harab himself is a brilliant and respected leader, and has often led large armies into battle."
#magicskill 1 3
#magicskill 3 2
#magicskill 4 2
#magicskill 5 3
#goodleader
#okmagicleader
#ressize 2
#startage 68
#maxage 75
#armor "Crown"
#weapon 105
#end

#newmonster 2422
#copystats 1003
#copyspr 509
#name "Great Seraphine"
#descr "The High priests of the new God, the Great Seraphines typically never leave their temples, but with the coming of the time of troubles occasionally one will seek to serve their God in a more direct way.  When they do join service they are revered as great leaders, and are the natural leaders of the risen Yasatas."
#clearmagic
#magicskill 6 3
#magicskill 5 3
#magicskill 8 3
#gcost 0
#goodleader
#okmagicleader
#holy
#nametype 111
#ressize 2
#maxage 75
#end

#newmonster 2423
#spr1 "./Harabatia/The Archer 1.tga"
#spr2 "./Harabatia/The Archer 2.tga"
#name "The Archer"
#descr "The archer in a wingless of Harabatia who left years ago to seek his fortune outside of his homeland, in time he became known as a great adventurer, learning to ride from the Horse Brothers, they gifted him with one of their incredible mounts on his leaving.  In his adventures he acquired many magical artifacts, and with the coming of the new God, has returned to Harabatia to aid his people. He is stealthy and trained in spying and assassination."
#hp 14
#str 12
#prot 0
#att 12
#mor 15
#def 14
#mr 12
#prec 18
#enc 2
#mapmove 3
#ap 27
#mounted
#weapon 356
#weapon 75
#weapon 56
#armor "Flame Helmet"
#armor "Black Steel Full Plate"
#armor "Shield of Valor"
#noleader
#forestsurvival
#mountainsurvival
#swampsurvival
#wastesurvival
#stealthy 20
#spy
#assassin
#itemslots 13446
#nametype 111
#size 3
#maxage 75
#gcost 200
#rcost 30
#end

#newmonster 2424
#spr1 "./Harabatia/Yazad Hero 1.tga"
#spr2 "./Harabatia/Yazad Hero 2.tga"
#name "Hero of the Yazad"
#descr "The hero of the yazad, like all of the Risen Yazatas, was trained from birth for combat; however, it quickly showed that he was far beyond his peers in skill.  Already considered sacred by his people, he has developed a certain authority as a priest, and often leads the Raptors in battle against the heathens, where he inspires them to great deeds.  He is equiped as a Risen Yasad."
#hp 18
#str 14
#mor 15
#mr 14
#enc 1
#att 14
#def 14
#prec 15
#mapmove 3
#ap 19
#size 3
#holy
#flying
#stormimmune
#weapon 473
#armor "Advanced Fireplate"
#armor "Shield"
#armor "Half Helmet"
#gcost 30
#rcost 2
#nametype 111
#ressize 2
#maxage 75
#standard 10
#expertleader
#magicskill 8 1
#end

#newmonster 2425
#spr1 "./Harabatia/Betrayer 1.tga"
#spr2 "./Harabatia/Betrayer 2.tga"
#name "Betrayer of Caelum"
#descr "The Betrayer of Caelum, was an Iceclad for the Caelian war machine, who, disillusioned with the Seraphs, traveled to Harabatia to see how they had fared, after seeing the great city and the Risen Yasads, he became convinced that the God of Harabatia is the one true God, and has pledged to serve for eternity. He is capable of bringing additional ice clads from Caelum to the cause."
#hp 9
#str 10
#att 12
#def 11
#mor 14
#mr 11
#prec 11
#enc 1
#mapmove 2
#ap 12
#weapon 37
#armor "Ice Hauberk"
#armor "Ice Helmet"
#armor "Ice Aegis"
#flying
#iceprot 2
#stormimmune
#coldres 100
#makemonster2 132
#goodleader
#end

--Summons--
#newmonster 2426
#name "Risen Troll King"
#descr "The trolls of Harabatia were once ruled by mighty kings, gifted in earth magic and skilled in combat.  After the death of the last king at the hands of Gerasha, the trolls converted to the ancestor worship of their masters.  Now with the aid of dark magics, the Harab Seraphs have raised up one of their most holy dead to aid the dark god.  Since the trolls do not mummify their dead, the king is but a skeleton, wielding ancient weapons.  The Risen King has lost some of his skill in earth magic, but has gained the use of death magic as well."
#spr1 "./Harabatia/troll king skeleton 1.tga"
#spr2 "./Harabatia/troll king skeleton 2.tga"
#hp 40
#prot 5
#size 3
#str 24
#mr 17
#att 11
#def 10
#prec 8
#mapmove 2
#ap 14
#mor 30
#enc 0
#holy
#goodleader
#goodundeadleader
#okmagicleader
#undead
#pooramphibian
#fireres -50
#neednoteat
#darkvision 100
#noheal
#regeneration 5
#magicskill 3 2
#magicskill 5 1
#magicskill 8 1
#mor 30
#weapon 14
#armor "Iron Cap"
#armor "Full Scale Mail"
#end

#newmonster 2427
#copystats 191
#copyspr 317
#name "Ancient Raptor"
#descr "In the cult of ancestor worship, the spirits and even the decomposing bodies of the ancient dead are considered holy.  This risen skeleton is little more than a husk, but it is imbued with the soul of an ancient raptor."
#holy
#hp 8
#weapon 29
#weapon 29
#armor "Rusty Scale Cuirass"
#end

#newmonster 2429
#copystats 150
#spr1 "./Harabatia/RaptorElephant.tga"
#name "Raptor Elephant Riders"
#descr "When the Raptors were forced to flee Caelum, they lost access to the mighty mammoths that served as the High Caelians ultimate war machine.  However, the knowledge of how to train them for battle stayed with them.  Then when the Raptors passed through Arcoscephale, Menala organized a daring raid, and a small herd of elephants was captured.  Now they raise the elephants on the slopes of Mount Raptor.  While they may not be as strong as the Caelian Mammoths, they serve a similar purpose."
#end

--Gods--

#newmonster 2428
#copyspr 1286
#copystats 1286
#name "Eagle King"
#descr "With the fall of the Pantokrator, the eldest of the Eagle Kings, ruler of the Yazatas, has returned to favor their chosen people as God. The Eagle King still practices the most ancient magics of Caelum, air and water, as well as the divine astral magic, however other paths of magic tend to be beyond his grasp."
#gcost 0
#rcost 0
#clearmagic
#mor 30
#magicskill 1 2
#magicskill 3 1
#magicskill 2 1
#pathcost 80
#startdom 2
#restrictedgod 72
#end

#newmonster 2430
#copystats 1003
#spr1 "./Harabatia/Arch Harab 1.tga"
#spr2 "./Harabatia/Arch Harab 2.tga"
#name "Arch Harab"
#descr "A Harab Seraph who has grown in power until almost godly, the Harab Seraph specializes in death and air magic, but can be a master of many magic paths."
#gcost 40
#mor 30
#clearspec
#flying
#clearmagic
#magicskill 1 1
#magicskill 5 1
#pathcost 10
#startdom 1
#restrictedgod 72
#end

#newsite 802
#name "Cathedral of the Ancestors"
#path 5
#level 4
#rarity 5
#gems 5 2
#homemon 2409
#homecom 2420
#end

#newsite 801
#name "Mount Raptor"
#path 3
#level 4
#rarity 5
#gems 1 1
#gems 3 1
#gems 6 1
#homecom 2419
#end

#newsite 803
#name "City of the Trolls"
#path 3
#level 4
#rarity 5
#homemon 2402
#homemon 2403
#homecom 2432
#end

#newspell
#name "Summon Eagle King"
#descr "The Eagle Kings were the ancient Yazata rulers of the united Caelum.  With the purifying of the blood among the raptors, the eagle kings have been pleased, and with proper sacrifice it may be possible to summon them to the world again."
#school 0
#researchlevel 4
#path 0 4
#pathlevel 0 2
#effect 10021
#damage 1286
#nreff 1
#restricted 72
#fatiguecost 1500
#end

#newspell
#name "Raise Troll King"
#descr "The Trolls of Harabatia were once ruled by powerful kings, skilled in earth magic.  Today, all the kings are dead, but to raise one from the dead would not be impossible."
#school 4
#researchlevel 4
#path 0 5
#path 1 3
#pathlevel 0 2
#pathlevel 1 1
#effect 10021
#damage 2426
#nreff 1
#restricted 72
#fatiguecost 1000
#end

#newspell
#name "Summon Elephant"
#descr "Through the intervention of a mage, an elephant is tamed for use by the Raptor armies."
#school 0
#researchlevel 2
#path 0 6
#pathlevel 0 2
#effect 10001
#damage 2429
#nreff 1
#restricted 72
#fatiguecost 400
#end

#newspell
#name "Holy Father"
#descr "The mage uses a holy ritual to reanimate the skeleton of an ancient raptor.  This ancient being is mindless and weak, but the people consider it holy."
#school 4
#researchlevel 0
#path 0 5
#pathlevel 0 1
#effect 10001
#damage 2427
#nreff 1
#restricted 72
#fatiguecost 100
#end

#newspell
#name "The Holy Dead"
#descr "The mage uses a holy ritual to reanimate the skeletons of several ancient raptors.  These ancient beings are mindless and weak, but the people consider them holy."
#school 4
#researchlevel 3
#path 0 5
#pathlevel 0 2
#effect 10001
#damage 2427
#nreff 1003
#restricted 72
#fatiguecost 800
#end

#newspell
#name "Knowledge of the Ancestors"
#descr "The raptors wandered the world for generations before they found their new home, in doing so they discovered many sites of great magical power. Using the power of many death gems, the caster summons the spirits of these ancient dead to tell him of the presence of all magic sites in a distant province."
#school 4
#researchlevel 4
#path 0 5
#pathlevel 0 3
#effect 10048
#fatiguecost 2500
#damage 55
#restricted 72
#end

#newspell
#copyspell "Haste"
#name "Wind Speed"
#descr "The wind is at your back, increasing the speed of some of your units"
#school 4
#researchlevel 2
#path 0 1
#pathlevel 0 1
#aoe 10
#fatiguecost 20
#restricted 72
#end

#newspell
#copyspell "Gateway"
#name "To Dust and From Dust"
#descr "All life is formed from the dust of the earth, and with this spell a mage can turn himself and all the troops under his command to dust, which flies on the breeze only to be reformed in a distant laboratory that has been prepared for the purpose.  A mage must be skilled in both earth and air magic in order to perform this complicated ritual."
#school 4
#researchlevel 5
#path 0 3
#path 1 1
#pathlevel 0 2
#pathlevel 1 3
#fatiguecost 1500
#restricted 72
#end

#selectnation 72
#name "Harabatia"
#epithet "The United Raptors"
#flag "/Harabatia/rapatiaflag.tga"
#era 2
#descr "When the dust of the Caelean civil war settled, and the Seraphs had asserted their control over Caelum and the Raptors were exiled, the Raptors were left essentially leaderless and angry at what remained of the Harab order of Seraphs for starting the war. Menala, leader of the Harab Seraphs after the death of his father, recognized that if the Raptors were to survive in the world at large they would need to unite.  Through blood, reform, and sheer political skill, he managed to gather most of the fractured clan under his leadership, and started them on their great Exile, a journey to find their new home that lasted for over 100 years.  During their journeys they passed through the ancient forests of Pangaea, and learned to command nature from the Pans.  Finally, when all hope seemed lost, the baleugered clans came on a great mountain surrounded by rich forests and inhabited by a small kingdom of trolls."
#summary "Race: stocky flyers, trolls, prefers cold scale +1.  Military: grounded archers, spears, harassing javelins and flyers, powerful trolls, and many elites.  Magic: Air, Death, Earth, Nature, Strong Mages, good researchers, and forging.  Priests: poor, no non capitol priests with more than 1 skill, few sacreds."
#brief "The raptors are flyers related to the Caelians who have subjegated a kingdom of trolls. Raptors lack the cold resistance of their cousins, but are larger of build.  They use earth, death, air, and nature magic."
#color .1 .8 .3
#addrecunit 2410 --Raptor Hunter
#addrecunit 2404 --Raptor Militia
#addrecunit 2405 --Raptor Homeguard
#addrecunit 2406 --Raptorian Warrior
#addrecunit 2431 --Raptor Axe Warrior
#addrecunit 2400 --Wingless Archers
#addrecunit 2401 --Wingless Raven
#addrecunit 2407 --Iron Crow
#addrecunit 2408 --Raven Guard
#addreccom 2411 --Raptor Scout
#addreccom 2412 --Crow Lord
#addreccom 2413 --Young Seraphine
#addreccom 2414 --Caretaker
#addreccom 2415 --Harab Seraph
#addreccom 2416 --Iron Crafter
#addreccom 2417 --Harab Naturalist
#addreccom 2418 --Harab Sage
#startcom 2412 --Crow Lord
#startsite "Cathedral of the Ancestors" --2D Risen Yasad Harab Seraphine
#startsite "Mount Raptor" --1A1E1N Raptor Elephant Riders
#startsite "City of the Trolls"
#startscout 2411 --Raptor Scout
#startunittype1 2405 --Raptor Home Guard
#startunitnbrs1 15
#startunittype2 2400 --Wingless Archers
#startunitnbrs2 15
#hero1 2422 --Great Seraphine
#hero2 2421 --Master Harab
#hero3 2423 --The Archer
#hero4 2424 --Hero of the Yazad
#hero5 2425 --Betrayer of Caelum
#defcom1 2412 --Crow Lord
#defcom2 2414 --Caretaker
#defunit1 2405 --Raptor Home Guard
#defunit1b 2400 --Wingless Archer
#defunit2 2406 --Raptor Warrior
#defmult1 10
#defmult1b 7
#defmult2 7
#idealcold 1
#templepic 2
#startfort 42
#defaultfort 8
#farmfort 8
#mountainfort 9
#forestfort 33
#swampfort 20
#end