#! /usr/bin/env python3.0
import os
import sys
import _thread
import shutil

tEmpty=0,0
tDom="SP","SP"
sIni="./DomScript.ini"
sDom=""
sExe=""
sMod=""
sSav=""
sTmp="."


print("------------------------------------------------------------------------------"+os.linesep)
print("Welcome to the Dom3 Scripting Framework"+os.linesep)
print("------------------------------------------------------------------------------"+os.linesep)

fTmp=open(sIni, "r")
while (sTmp!=""):
	sTmp=fTmp.readline()
	if sTmp.startswith("Dompath="):
		sTmp=sTmp.rstrip(os.linesep)
		sDom=sTmp.lstrip("Dompath=")
	if sTmp.startswith("Exepath="):
		sTmp=sTmp.rstrip(os.linesep)
		sExe=sTmp.lstrip("Exepath=")
	if sTmp.startswith("Modpath="):
		sTmp=sTmp.rstrip(os.linesep)
		sMod=sTmp.lstrip("Modpath=")
	if sTmp.startswith("Savepath="):
		sTmp=sTmp.rstrip(os.linesep)
		sSav=sTmp.lstrip("Savepath=")

#print("Dom3 Exe:"+sExe)
#print("Dom3 Mods:"+sMod)
#print("Dom3 Saves:"+sSav)


print("Select a game")
print("0) Quit"+os.linesep)
tTmp=os.listdir(sSav)

i=0
for sTmp in tTmp:
	i=i+1
	print(str(i) + ") " + sTmp)


sTmp=input()

#getting game directories and status, setting it up
if not sTmp.isdigit:
	exit("user can't type... and i don't know python")
elif sTmp=="0":
	exit("user wanted it...")	
else:
	sGame=tTmp[int(sTmp) - 1]
	sFrame="SF_"+sGame
	sTGame=sSav+sGame
	sTFrame=sSav+sFrame

#	print(sGame)
#	print(sFrame)
#	print(sTGame)
#	print(sTFrame)

	if os.path.exists(sTGame+"/ftherlnd"):
		#Set the game up for the Framework
		shutil.copytree(sTGame, sTFrame)
		os.remove(sTGame+"/ftherlnd")

#the infinite loop
#1) update the mods
#2) play the turn
#3) Check if turn was ended for real
#4) if not break
#4) if yes host and goto 1)

i=0	
while i==0:
	#update the mod - run all scripts in sMod+"/Frame/mod/"
	tTmp=os.listdir(sMod+"Frame/mods/")
	for sTmp in tTmp:
		if sTmp.find(".py")!=-1:
			tDom="",sMod,sGame,sTFrame
			os.spawnvp(os.P_WAIT, sMod+"Frame/mods/"+sTmp, tDom)
			
#	break
	#play the next turn
	tDom="",sDom,sGame,sMod+"Frame/log/playlog"
	os.spawnvp(os.P_WAIT, sExe, tDom);

	with open(sMod+"/Frame/log/playlog", "r") as fLog:
		sLog=fLog.read()
		if sLog.find("addcrc: done"+os.linesep+"  for real")==-1:
			print("Saving...")
			break
		else:
			print("Hosting...")
			#copy the 2hs
			tTmp=os.listdir(sTGame+"/")
			for sTmp in tTmp:
				if sTmp.find(".2h")!=-1:
					shutil.copy(sTGame+"/"+sTmp,sTFrame+"/"+sTmp)

			#host
			tDom="",sDom,"--host "+sFrame,sMod+"Frame/log/hostlog"
			os.spawnvp(os.P_WAIT, sExe, tDom);

			#copy the trns
			tTmp=os.listdir(sTGame+"/")
			for sTmp in tTmp:
				if sTmp.find(".trn")!=-1:
					shutil.copy(sTFrame+"/"+sTmp,sTGame+"/"+sTmp)


			
		
print("------------------------------------------------------------------------------"+os.linesep)
print("Thanks for using the Dom3 Scripting Framework");
