#! /usr/bin/env python3.0

# Something upfront:
# Everything behind these "#" is a comment, meaning it is ignored for executing the script
# Any line without it is executed (completely the other way round than dom3 mods)
# So if you don't know python, read all of these, as they will contain useful info

#####################################################################################################################################################
# Keep everything in here if you want to use the API
from sys import argv
from _dtsfapi import *
#####################################################################################################################################################


#####################################################################################################################################################
# That's the point where your mod script goes
# Keep everything
def CheckLine(LineText, LineNumber, ScoreInfo):

	Turn=ScoreInfo[0]
	Nations=ScoreInfo[1]
	Provinces=ScoreInfo[2]
	Forts=ScoreInfo[3]
	Income=ScoreInfo[4]
	GemIncome=ScoreInfo[5]
	Research=ScoreInfo[6]
	Dominion=ScoreInfo[7]
	ArmySize=ScoreInfo[8]
	VictoryPoints=ScoreInfo[9]

# ok, some info on the info you have
# pretty straightforward what everything is, but how do you get say the Income of the 3rd player?
# simple:
# Income[3]
#
# And how do you get the Number of provinces of Sauro? You need to get the player number of sauro first with GetNationNumber.
# This is best explained by the example I provided
#
#####################################################################################################################################################


#####################################################################################################################################################
# All the changes you do go in here
#
# It works like this:
# This goes over every Line of your Template mod, executes any changes you order here and constructs the real mod out of it line by line
# So technically that means the code in here is executed x times. Once for every line in your template.
#
# First thing is you have to find out for which line the code is executed currently
# You do this with the "if LineNumber==x:" statements
# after any "if" statement you need an indentation (TAB key)
# once you make lines without indentation you are no longer doing them under the if condition
#
# Remember how I said the Template should contain all lines that come into the finished mod, only the dynamic ones as comments?
# That helps you to keep track of any errors you make, like slipping a line
# just open the template, go through the lines that ought to change and check if their line numbers correspond with those in the script
#
# If you want to turn a line on just use ActivateLine
# If the line contains a variable use VariableInLine
# Otherwise do nothing

	#ActivateLine example

#	var3=11512
	if Turn<=1:
		var2=0
		var3=0
	elif Turn<=12 and Turn>=2:
		var2=12
		var3=2
	elif Turn<=24 and Turn>=13:
		var2=24
		var3=4
	elif Turn<=36 and Turn>=25:
		var2=36
		var3=6
	elif Turn<=48 and Turn>=37:
		var2=48
		var3=8
	else:
		var2=60
		var3=10


#	var2=12*(Turn-1)
	var1=0
	while var1<=(14548-11512):
		if LineNumber>=(11512+var2+var1) and LineNumber<=(11521+var2+var1):
			LineText=ActivateLine(LineText)
		if LineNumber==(11583+var3+var1):
			LineText=ActivateLine(LineText)
		var1=var1+132

	return LineText
#####################################################################################################################################################


#####################################################################################################################################################
# Keep everything in here if you want to use the API
ModName=sys.argv[0]
ModName=ModName.replace(".py",".dm")
ModName=ModName.replace(sys.argv[1]+"Frame/mods/","")
GameName=sys.argv[2]
WorkingFolder=sys.argv[3]


Template=sys.argv[1]+"Frame/mods/"+ModName
Mod=sys.argv[1]+ModName
print(ModName)
print("		Game:	"+GameName)
print("		Creating mod")
#####################################################################################################################################################


#####################################################################################################################################################
# This is the API function that creates the Mod	- keep everything	^
# It uses the CheckLine function, so look there for more explanation 	|
ConstructMod(WorkingFolder, GameName, Template, Mod, CheckLine)
print("		Mod file created")
exit()
#####################################################################################################################################################
