#! /usr/bin/env python3.0

# Something upfront:
# Everything behind these "#" is a comment, meaning it is ignored for executing the script
# Any line without it is executed (completely the other way round than dom3 mods)
# So if you don't know python already, read all of these, as they will contain useful info
#
# 
#
#

# Firstly, the API is meant to keep it easy for you.
# 
#

#on what you can do and on security
# I have left the option to let you access


#####################################################################################################################################################
# Keep everything in here if you want to use the API
from sys import argv
from _dtsfapi import *
#####################################################################################################################################################


#####################################################################################################################################################
# That's the point where your mod script goes
# Keep everything
def CheckLine(LineText, LineNumber, ScoreInfo):

	Turn=ScoreInfo[0]
	Nations=ScoreInfo[1]
	Provinces=ScoreInfo[2]
	Forts=ScoreInfo[3]
	Income=ScoreInfo[4]
	GemIncome=ScoreInfo[5]
	Research=ScoreInfo[6]
	Dominion=ScoreInfo[7]
	ArmySize=ScoreInfo[8]
	VictoryPoints=ScoreInfo[9]

# ok, some info on the info you have
# pretty straightforward what everything is, but how do you get say the Income of the 3rd player?
# simple:
# Income[3]
#
# And how do you get the Number of provinces of Sauro? You need to get the player number of sauro first with GetNationNumber.
# This is best explained by the example I provided
#
#####################################################################################################################################################


#####################################################################################################################################################
# All the changes you do go in here
#
# It works like this:
# This goes over every Line of your Template mod, executes any changes you order here and constructs the real mod out of it line by line
# So technically that means the code in here is executed x times. Once for every line in your template.
#
# First thing is you have to find out for which line the code is executed currently
# You do this with the "if LineNumber==x:" statements
# after any "if" statement you need an indentation (TAB key)
# once you make lines without indentation you are no longer doing them under the if condition
#
# Remember how I said the Template should contain all lines that come into the finished mod, only the dynamic ones as comments?
# That helps you to keep track of any errors you make, like slipping a line
# just open the template, go through the lines that ought to change and check if their line numbers correspond with those in the script
#
# If you want to turn a line on just use ActivateLine
# If the line contains a variable use VariableInLine
# Otherwise do nothing

	#ActivateLine example
	if LineNumber==11:
		#means everything that's indented twice is executed on the 11th line
		LineText=ActivateLine(LineText)
		#Activates the Line in question

	#ok, this is silly, the line is always on
	#lets do an example on how to use the info from score files
	if LineNumber==13:
		if Turn==13:
			LineText=ActivateLine(LineText)
			#means line 13 is active on turn 13 only, otherwise outcommented
			#indentation here also!
		#if you'd you put the ActivateLine command here it would again always activate the line not only when the turn is 13

	#another example
	if LineNumber==12 or LineNumber==15:
		if Forts[1]>=3:
			LineText=ActivateLine(LineText)
			#means line 12 and 15 are active when the 1st nation in the scoregraphs has 3 forts or more


	#finally two examples of using VariableinLine and NationNumber
	if LineNumber==16:
		var1=NationNumber(Nations, "Sauromatia")
		if var1!=-1:
			#gets the player number of Sauromatia, !=-1 means is Sauro isn't in the game, and the changes should not be applied
			var2=str(Provinces[var1]/5)
			LineText=VariableInLine(LineText, var2)
			#means that the $var you put into line 16 is replaced by the Sauromatia's Provinces/5
			#str makes a string out of a number (for when you want it to feature in descriptions)

	if LineNumber==20:
		var1=NationNumber(Nations, "Sauromatia")
		if var1!=-1:
			var2=int(Provinces[var1]/5)
			LineText=VariableInLine(LineText, var2)
			#means that the $var you put into line 20 is replaced by the Sauromatia's Provinces/5
			#int is necessary when dividing (it rounds).
			#quick rule of thumb: int before numbers, str before descriptions, names, etc
			#VariableinLine activates the line automatically

	return LineText	# just to let the framework know we are finished, keep it
#####################################################################################################################################################


#####################################################################################################################################################
# Keep everything in here if you want to use the API
ModName=sys.argv[0]
ModName=ModName.replace(".py",".dm")
ModName=ModName.replace(sys.argv[1]+"Frame/mods/","")
GameName=sys.argv[2]
WorkingFolder=sys.argv[3]


Template=sys.argv[1]+"Frame/mods/"+ModName
Mod=sys.argv[1]+ModName
print(ModName)
print("		Game:	"+GameName)
print("		Creating mod")
#####################################################################################################################################################


#####################################################################################################################################################
# This is the API function that creates the Mod	- keep everything	^
# It uses the CheckLine function, so look there for more explanation 	|
ConstructMod(WorkingFolder, GameName, Template, Mod, CheckLine)
print("		Mod file created")
exit()
#####################################################################################################################################################
