/*
 * Decompiled with CFR 0.152.
 */
package com.ap.d3.controller;

import com.ap.d3.D3Project;
import com.ap.d3.controller.exception.D3Exception;
import com.ap.d3.controller.magic.Grimoire;
import com.ap.d3.fwk.controller.IGrimoire;
import com.ap.d3.fwk.model.IResearch;
import com.ap.d3.model.magic.Effect;
import com.ap.d3.model.magic.Item;
import com.ap.d3.model.magic.ItemCategory;
import com.ap.d3.model.magic.ItemType;
import com.ap.d3.model.magic.Magics;
import com.ap.d3.model.magic.Path;
import com.ap.d3.model.magic.PathLevel;
import com.ap.d3.model.magic.Research;
import com.ap.d3.model.magic.School;
import com.ap.d3.model.magic.SchoolLevel;
import com.ap.d3.model.magic.Spell;
import com.ap.d3.model.magic.SpellType;
import com.ap.tools.xml.XMLMethods;
import java.util.List;
import org.w3c.dom.Node;

public class D3Controller {
    private static D3Controller _instance;
    private Research _research;

    private D3Controller() {
    }

    public static D3Controller getInstance() {
        if (_instance == null) {
            _instance = new D3Controller();
            _instance.loadPaths();
            _instance.loadSchools();
            _instance.loadEffects();
            _instance.loadSpells();
            _instance.loadItems();
        }
        return _instance;
    }

    public IGrimoire getGrimoire() {
        return Grimoire.getGrimoire();
    }

    public IResearch getResearch() {
        return this._research;
    }

    private void loadPaths() {
        try {
            Node nPaths = XMLMethods.getRootNodeFromFile(D3Project.getInstance().getFileLoader().getAbsolutePath("resources/model/magic/paths.xml"), "paths");
            List<Node> listNodePath = XMLMethods.getChildNodes(nPaths, "path");
            for (Node nodePath : listNodePath) {
                String id = XMLMethods.getAttribute(nodePath, "id");
                String name = XMLMethods.getAttribute(nodePath, "name");
                Path path = Path.Factory.newPath(id, name);
                Grimoire.getGrimoire().addPath(path, true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void loadSchools() {
        this._research = new Research();
        try {
            Node nSchools = XMLMethods.getRootNodeFromFile(D3Project.getInstance().getFileLoader().getAbsolutePath("resources/model/magic/schools.xml"), "schools");
            List<Node> listNodeSchool = XMLMethods.getChildNodes(nSchools, "school");
            for (Node nodeSchool : listNodeSchool) {
                String id = XMLMethods.getAttribute(nodeSchool, "id");
                String name = XMLMethods.getAttribute(nodeSchool, "name");
                School school = new School(id, name);
                Grimoire.getGrimoire().addSchool(school, true);
                List<Node> listNodeSchoolLevel = XMLMethods.getChildNodes(nodeSchool, "level");
                for (Node nodeLevel : listNodeSchoolLevel) {
                    String levelId = XMLMethods.getAttribute(nodeLevel, "id");
                    String levelName = XMLMethods.getAttribute(nodeLevel, "name");
                    SchoolLevel level = new SchoolLevel(school, levelId, levelName);
                    Grimoire.getGrimoire().addSchoolLevel(level, true);
                }
            }
            for (Node nodeSchool : listNodeSchool) {
                String schoolId = XMLMethods.getAttribute(nodeSchool, "id");
                List<Node> listNodeSchoolLevel = XMLMethods.getChildNodes(nodeSchool, "level");
                for (Node nodeLevel : listNodeSchoolLevel) {
                    String levelId = nodeLevel.getAttributes().getNamedItem("id").getNodeValue();
                    SchoolLevel level = Grimoire.getGrimoire().getSchoolLevel(levelId);
                    String requireId = XMLMethods.getAttribute(nodeLevel, "requires");
                    if (requireId != null) {
                        SchoolLevel requirement = Grimoire.getGrimoire().getSchoolLevel(requireId);
                        level.setRecquirement(requirement);
                    } else {
                        this._research.setLevel(schoolId, levelId);
                    }
                    String unlockId = XMLMethods.getAttribute(nodeLevel, "unlock");
                    if (unlockId == null) continue;
                    SchoolLevel unlock = Grimoire.getGrimoire().getSchoolLevel(unlockId);
                    level.setUnlock(unlock);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void loadEffects() {
        try {
            Node nEffects = XMLMethods.getRootNodeFromFile(D3Project.getInstance().getFileLoader().getAbsolutePath("resources/model/magic/effects.xml"), "effects");
            List<Node> listNodeEffect = XMLMethods.getChildNodes(nEffects, "effect");
            for (Node nodeEffect : listNodeEffect) {
                String id = XMLMethods.getAttribute(nodeEffect, "id");
                String name = XMLMethods.getAttribute(nodeEffect, "name");
                Effect effect = Effect.Factory.newEffect(id, name);
                Grimoire.getGrimoire().addEffect(effect, true);
            }
        }
        catch (Exception ex) {
            System.exit(0);
        }
    }

    private void loadSpells() {
        try {
            Node nSpellTags = XMLMethods.getRootNodeFromFile(D3Project.getInstance().getFileLoader().getAbsolutePath("resources/model/magic/spelltags.xml"), "spelltags");
            Node nTypes = XMLMethods.getFirstChildNode(nSpellTags, "types");
            List<Node> listNodeSpellType = XMLMethods.getChildNodes(nTypes, "type");
            for (Node nodeType : listNodeSpellType) {
                String id = XMLMethods.getAttribute(nodeType, "id");
                String name = XMLMethods.getAttribute(nodeType, "name");
                SpellType spellType = new SpellType(id, name);
                Grimoire.getGrimoire().addSpellType(spellType, true);
            }
            Node nSpells = XMLMethods.getRootNodeFromFile(D3Project.getInstance().getFileLoader().getAbsolutePath("resources/model/magic/spells.xml"), "spells");
            List<Node> listNodeSpell = XMLMethods.getChildNodes(nSpells, "spell");
            for (Node nodeSpell : listNodeSpell) {
                String id = XMLMethods.getAttribute(nodeSpell, "id");
                String name = XMLMethods.getAttribute(nodeSpell, "name");
                String school = XMLMethods.getAttribute(nodeSpell, "school");
                SchoolLevel msl = Grimoire.getGrimoire().getSchoolLevel(school);
                String type = XMLMethods.getAttribute(nodeSpell, "type");
                SpellType st = Grimoire.getGrimoire().getSpellType(type);
                Node nodeDesc = XMLMethods.getFirstChildNode(nodeSpell, "description");
                String desc = nodeDesc.getTextContent().trim();
                Node nodeFatigue = XMLMethods.getFirstChildNode(nodeSpell, "fatigue");
                int fatigue = new Integer(nodeFatigue.getTextContent().trim());
                Node nodePaths = XMLMethods.getFirstChildNode(nodeSpell, "paths");
                PathLevel[] paths = this.getPaths(nodePaths);
                Node nodeGems = XMLMethods.getFirstChildNode(nodeSpell, "gems");
                PathLevel[] gems = this.getGems(nodeGems);
                Spell spell = new Spell(msl, paths, st, id, name, desc, fatigue, gems);
                Grimoire.getGrimoire().addSpell(spell, true);
            }
        }
        catch (Exception ex) {
            System.exit(0);
        }
    }

    private void loadItems() {
        try {
            Node nItemTags = XMLMethods.getRootNodeFromFile(D3Project.getInstance().getFileLoader().getAbsolutePath("resources/model/magic/itemtags.xml"), "itemtags");
            Node nCategories = XMLMethods.getFirstChildNode(nItemTags, "categories");
            List<Node> listNodeCategory = XMLMethods.getChildNodes(nCategories, "category");
            for (Node nodeCategory : listNodeCategory) {
                String id = XMLMethods.getAttribute(nodeCategory, "id");
                String name = XMLMethods.getAttribute(nodeCategory, "name");
                String cnstlvl = XMLMethods.getAttribute(nodeCategory, "csntlevel");
                SchoolLevel schoolLevel = Grimoire.getGrimoire().getSchoolLevel(cnstlvl);
                ItemCategory itemCategory = new ItemCategory(schoolLevel, id, name);
                Grimoire.getGrimoire().addItemCategory(itemCategory, true);
            }
            Node nTypes = XMLMethods.getFirstChildNode(nItemTags, "types");
            List<Node> listNodeType = XMLMethods.getChildNodes(nTypes, "type");
            for (Node nodeType : listNodeType) {
                String id = XMLMethods.getAttribute(nodeType, "id");
                String name = XMLMethods.getAttribute(nodeType, "name");
                ItemType itemType = new ItemType(id, name);
                Grimoire.getGrimoire().addItemType(itemType, true);
            }
            Node nItems = XMLMethods.getRootNodeFromFile(D3Project.getInstance().getFileLoader().getAbsolutePath("resources/model/magic/items.xml"), "items");
            List<Node> listNodeItem = XMLMethods.getChildNodes(nItems, "item");
            for (Node nodeItem : listNodeItem) {
                String id = XMLMethods.getAttribute(nodeItem, "id");
                String name = XMLMethods.getAttribute(nodeItem, "name");
                String type = XMLMethods.getAttribute(nodeItem, "type");
                ItemType itemType = Grimoire.getGrimoire().getItemType(type);
                String cat = XMLMethods.getAttribute(nodeItem, "cat");
                ItemCategory itemCategory = Grimoire.getGrimoire().getItemCategory(cat);
                Node nodeDesc = XMLMethods.getFirstChildNode(nodeItem, "description");
                String desc = nodeDesc.getTextContent().trim();
                Node nodePaths = XMLMethods.getFirstChildNode(nodeItem, "paths");
                PathLevel[] paths = this.getPaths(nodePaths);
                Node nodeGems = XMLMethods.getFirstChildNode(nodeItem, "gems");
                PathLevel[] gems = this.getGems(nodeGems);
                Item item = new Item(itemType, itemCategory, id, name, desc, paths, gems, new Effect[0]);
                Grimoire.getGrimoire().addItem(item, true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private PathLevel[] getPaths(Node nodePaths) throws D3Exception {
        List<Node> listNodePath = XMLMethods.getChildNodes(nodePaths, "path");
        PathLevel[] arrayPathLevel = new PathLevel[listNodePath.size()];
        int i = 0;
        while (i < listNodePath.size()) {
            Node nodePath = listNodePath.get(i);
            String value = nodePath.getTextContent().trim();
            arrayPathLevel[i] = Magics.getPathFromString(value);
            ++i;
        }
        return arrayPathLevel;
    }

    private PathLevel[] getGems(Node nodeGems) throws D3Exception {
        List<Node> listNodeGem = XMLMethods.getChildNodes(nodeGems, "gem");
        PathLevel[] arrayPathLevel = new PathLevel[listNodeGem.size()];
        int i = 0;
        while (i < listNodeGem.size()) {
            Node nodeGem = listNodeGem.get(i);
            String value = nodeGem.getTextContent().trim();
            arrayPathLevel[i] = Magics.getPathFromString(value);
            ++i;
        }
        return arrayPathLevel;
    }
}

