/*
 * Decompiled with CFR 0.152.
 */
package com.ap.d3.ui;

import com.ap.d3.controller.D3Controller;
import com.ap.d3.fwk.model.IEffect;
import com.ap.d3.fwk.model.IItem;
import com.ap.d3.fwk.model.ISchoolLevel;
import com.ap.d3.fwk.model.ISpell;
import com.ap.d3.model.magic.Magics;
import com.ap.d3.ui.EItemHierarchy;
import com.ap.d3.ui.ESpellHierarchy;
import com.ap.d3.ui.group.GroupItem;
import com.ap.d3.ui.group.GroupItemList;
import com.ap.d3.ui.group.GroupSpell;
import com.ap.d3.ui.group.GroupSpellList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class D3View {
    private static D3View _instance;
    public static final Font FONT_TAHOMA_10_BOLD;
    public static final Font FONT_VERDANA_6;
    public static final Font FONT_VERDANA_5;
    public static final Font FONT_VERDANA_4;
    private List<IEffect> _listEffectFilters;
    private Map<String, Boolean> _mapSpellTypeFilter = new HashMap<String, Boolean>();
    private Map<String, Boolean> _mapCategoryFilter;
    private Map<String, Boolean> _mapItemTypeFilter;
    private Map<String, ISchoolLevel> _mapSchoolFilters;
    private Magics _pathFilters;
    private GroupSpell _groupSpell;
    private GroupSpellList _groupSpellList;
    private GroupItem _groupItem;
    private GroupItemList _groupItemList;
    private ESpellHierarchy _spellHierarchy;
    private EItemHierarchy _itemHierarchy;
    private ISpell _spell;
    private IItem _item;

    static {
        FONT_TAHOMA_10_BOLD = new Font((Device)Display.getCurrent(), "Tahoma", 10, 1);
        FONT_VERDANA_6 = new Font((Device)Display.getCurrent(), "Verdana", 6, -1);
        FONT_VERDANA_5 = new Font((Device)Display.getCurrent(), "Verdana", 5, -1);
        FONT_VERDANA_4 = new Font((Device)Display.getCurrent(), "Verdana", 4, -1);
    }

    private D3View() {
        Object type;
        Object[] objectArray = D3Controller.getInstance().getGrimoire().getSpellTypes();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            type = objectArray[n2];
            this._mapSpellTypeFilter.put(type.getId(), new Boolean(true));
            ++n2;
        }
        this._mapItemTypeFilter = new HashMap<String, Boolean>();
        objectArray = D3Controller.getInstance().getGrimoire().getItemTypes();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            type = objectArray[n2];
            this._mapItemTypeFilter.put(type.getId(), new Boolean(true));
            ++n2;
        }
        this._mapCategoryFilter = new HashMap<String, Boolean>();
        objectArray = D3Controller.getInstance().getGrimoire().getItemCategories();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object cat = objectArray[n2];
            this._mapCategoryFilter.put(cat.getId(), new Boolean(true));
            ++n2;
        }
        this._mapSchoolFilters = new HashMap<String, ISchoolLevel>();
        objectArray = D3Controller.getInstance().getGrimoire().getSchools();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object school = objectArray[n2];
            this._mapSchoolFilters.put(school.getId(), D3Controller.getInstance().getResearch().getCurrentLevel(school.getId()));
            ++n2;
        }
        this._listEffectFilters = new ArrayList<IEffect>();
        this._pathFilters = Magics.Factory.getEmptyMagics();
    }

    public static D3View getInstance() {
        if (_instance == null) {
            _instance = new D3View();
        }
        return _instance;
    }

    public void registerGroupSpell(GroupSpell gSpell) {
        this._groupSpell = gSpell;
    }

    public void registerGroupSpellList(GroupSpellList gSpellList) {
        this._groupSpellList = gSpellList;
    }

    public void registerGroupItem(GroupItem gItem) {
        this._groupItem = gItem;
    }

    public void registerGroupItemList(GroupItemList gItemList) {
        this._groupItemList = gItemList;
    }

    public void notifySpellSelection(ISpell spell) {
        if (spell == null) {
            this._groupSpell.update(null);
        } else {
            if (spell.equals(this._spell)) {
                return;
            }
            this._groupSpell.update(spell);
        }
    }

    public void notifyItemSelection(IItem item) {
        if (item == null) {
            this._groupItem.update(null);
        } else {
            if (item.equals(this._item)) {
                return;
            }
            this._groupItem.update(item);
        }
    }

    public ESpellHierarchy getSpellHierarchy() {
        return this._spellHierarchy;
    }

    public void changeSpellHierarchy(String sSpellHierarchy) {
        ESpellHierarchy spellHierarchy = ESpellHierarchy.getByName(sSpellHierarchy);
        if (spellHierarchy == null) {
            spellHierarchy = ESpellHierarchy.getDefault();
        }
        if (spellHierarchy.equals((Object)this._spellHierarchy)) {
            return;
        }
        this._spellHierarchy = spellHierarchy;
        this.notifySpellTree();
    }

    public EItemHierarchy getItemHierarchy() {
        return this._itemHierarchy;
    }

    public void changeItemHierarchy(String sItemHierarchy) {
        EItemHierarchy itemHierarchy = EItemHierarchy.getByName(sItemHierarchy);
        if (itemHierarchy == null) {
            itemHierarchy = EItemHierarchy.getDefault();
        }
        if (itemHierarchy.equals((Object)this._itemHierarchy)) {
            return;
        }
        this._itemHierarchy = itemHierarchy;
        this.notifyItemTree();
    }

    public void changeEffectFilter(List<IEffect> effects) {
        this.notifyItemFilters();
        this.notifySpellFilters();
    }

    public boolean getSpellTypeFilter(String typeId) {
        return this._mapSpellTypeFilter.get(typeId);
    }

    public void changeSpellTypeFilter(String typeId, boolean b) {
        this._mapSpellTypeFilter.put(typeId, new Boolean(b));
        this.notifySpellFilters();
    }

    public boolean getItemTypeFilter(String typeId) {
        return this._mapItemTypeFilter.get(typeId);
    }

    public void changeItemTypeFilter(String typeId, boolean b) {
        this._mapItemTypeFilter.put(typeId, new Boolean(b));
        this.notifyItemFilters();
    }

    public boolean getCategoryFilter(String catId) {
        return this._mapCategoryFilter.get(catId);
    }

    public void changeCategoryFilter(String catId, boolean b) {
        this._mapCategoryFilter.put(catId, new Boolean(b));
        this.notifyItemFilters();
    }

    public ISchoolLevel getSchoolFilter(String schoolId) {
        return this._mapSchoolFilters.get(schoolId);
    }

    public void changeSchoolFilter(String schoolId, ISchoolLevel level) {
        this._mapSchoolFilters.put(schoolId, level);
        this.notifySpellFilters();
    }

    public boolean hasPathFilter() {
        return this._pathFilters.countPaths() > 0;
    }

    public void changePathFilter(Magics magics) {
        this._pathFilters = magics;
        this.notifySpellFilters();
        this.notifyItemFilters();
    }

    public Magics getPathFilters() {
        return this._pathFilters;
    }

    public boolean hasEffectFilter() {
        return this._listEffectFilters.size() > 0;
    }

    public void changeEffectFilter(IEffect effect, boolean in) {
        this._listEffectFilters.remove(effect);
        if (in) {
            this._listEffectFilters.add(effect);
        }
        this.notifySpellFilters();
        this.notifyItemFilters();
    }

    public List<IEffect> getEffectFilters() {
        return this._listEffectFilters;
    }

    private void notifySpellTree() {
        this._groupSpellList.updateHierarchy();
    }

    private void notifyItemTree() {
        this._groupItemList.updateHierarchy();
    }

    private void notifySpellFilters() {
        this._groupSpellList.updateFilters();
    }

    private void notifyItemFilters() {
        this._groupItemList.updateFilters();
    }
}

