/*
 * Decompiled with CFR 0.152.
 */
package com.ap.d3.ui.group;

import com.ap.d3.fwk.model.IItem;
import com.ap.d3.ui.D3View;
import com.ap.d3.ui.composite.CompositeGems;
import com.ap.d3.ui.composite.CompositePaths;
import com.ap.d3.ui.label.LabelHead;
import com.ap.d3.ui.label.LabelHeadData;
import com.ap.tools.image.D3ImageCache;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

public class GroupItem {
    private Group _groupItem;
    private Label _labelImage;
    private LabelHeadData _labelName;
    private LabelHeadData _labelCategory;
    private LabelHeadData _labelType;
    private CompositePaths _compositePaths;
    private CompositeGems _compositeGems;
    private Label _labelDescription;

    public GroupItem(Composite parent, int hSpan, int vSpan) {
        this._groupItem = new Group(parent, 64);
        this._labelImage = new Label(this._groupItem, 2048);
        GridData gridData = new GridData(0x1000000, 0x1000000, false, false, 2, 1);
        gridData.widthHint = 64;
        gridData.heightHint = 64;
        this._labelImage.setLayoutData(gridData);
        this._labelName = new LabelHeadData(this._groupItem, "Item :");
        this._labelType = new LabelHeadData(this._groupItem, "Type :");
        this._labelCategory = new LabelHeadData(this._groupItem, "Category :");
        new LabelHead(this._groupItem, "Forging Path :");
        this._compositePaths = new CompositePaths(this._groupItem, 4);
        new LabelHead(this._groupItem, "Forging Cost :");
        this._compositeGems = new CompositeGems(this._groupItem, 4);
        this._labelDescription = new Label(this._groupItem, 64);
        this._labelDescription.setLayoutData(new GridData(4, 4, false, true, 2, 1));
        this._groupItem.setText("Please select an item");
        this._groupItem.setFont(D3View.FONT_TAHOMA_10_BOLD);
        this._groupItem.setLayout(new GridLayout(2, false));
        this._groupItem.setLayoutData(new GridData(4, 4, true, false, hSpan, vSpan));
        D3View.getInstance().registerGroupItem(this);
    }

    public void update(IItem item) {
        if (item == null) {
            this._labelImage.setImage(null);
            this._labelName.reset();
            this._labelCategory.reset();
            this._labelType.reset();
            this._labelDescription.setText("");
            this._compositePaths.reset();
            this._compositeGems.reset();
            this._groupItem.setText("Please select an item");
        } else {
            this._labelImage.setImage(D3ImageCache.getInstance().getImageItem(item, 64));
            this._labelName.update(item.getName());
            this._labelCategory.update(item.getCategory().getName());
            this._labelType.update(item.getType().getName());
            this._labelDescription.setText(item.getDescription());
            this._compositePaths.update(item.getForgingPaths());
            this._compositeGems.update(item.getForgingCosts());
            this._groupItem.setText(item.getName());
        }
        this._labelImage.update();
        this._labelDescription.update();
        this._groupItem.update();
    }
}

