/*
 * Decompiled with CFR 0.152.
 */
package com.ap.d3.ui.group;

import com.ap.d3.fwk.model.ISpell;
import com.ap.d3.ui.D3View;
import com.ap.d3.ui.composite.CompositeGems;
import com.ap.d3.ui.composite.CompositePaths;
import com.ap.d3.ui.label.LabelHead;
import com.ap.d3.ui.label.LabelHeadData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

public class GroupSpell {
    private Group _groupSpell;
    private LabelHeadData _labelName;
    private LabelHeadData _labelSchool;
    private LabelHeadData _labelFatigue;
    private CompositePaths _compositePaths;
    private CompositeGems _compositeGems;
    private Label _labelDescription;

    public GroupSpell(Composite parent, int hSpan, int vSpan) {
        this._groupSpell = new Group(parent, 0);
        this._labelName = new LabelHeadData(this._groupSpell, "Spell :");
        this._labelSchool = new LabelHeadData(this._groupSpell, "School :");
        this._labelFatigue = new LabelHeadData(this._groupSpell, "Fatigue :");
        new LabelHead(this._groupSpell, "Path :");
        this._compositePaths = new CompositePaths(this._groupSpell, 2);
        new LabelHead(this._groupSpell, "Gem Cost :");
        this._compositeGems = new CompositeGems(this._groupSpell, 1);
        this._labelDescription = new Label(this._groupSpell, 64);
        this._labelDescription.setLayoutData(new GridData(4, 4, false, true, 2, 1));
        this._groupSpell.setText("Spell");
        this._groupSpell.setFont(D3View.FONT_TAHOMA_10_BOLD);
        this._groupSpell.setLayout(new GridLayout(2, false));
        this._groupSpell.setLayoutData(new GridData(4, 4, true, false, hSpan, vSpan));
        D3View.getInstance().registerGroupSpell(this);
    }

    public void update(ISpell spell) {
        if (spell == null) {
            this._labelName.reset();
            this._labelSchool.reset();
            this._labelFatigue.reset();
            this._labelDescription.setText("");
            this._compositePaths.reset();
            this._compositeGems.reset();
            this._groupSpell.setText("Please select a spell");
        } else {
            this._labelName.update(spell.getName());
            this._labelFatigue.update("" + spell.getFatigue());
            this._labelDescription.setText(spell.getDescription());
            if (spell.hasSchool()) {
                this._labelSchool.update(spell.getSchoolLevel().getName());
            } else {
                this._labelSchool.update("Not assigned to a magic school.");
            }
            this._compositePaths.update(spell.getPathLevels());
            if (spell.getGemCost() != null) {
                this._compositeGems.update(spell.getGemCost());
            } else {
                this._compositeGems.reset();
            }
            this._groupSpell.setText(spell.getName());
        }
        this._labelDescription.update();
        this._groupSpell.update();
    }
}

