/*
 * Decompiled with CFR 0.152.
 */
package com.ap.d3.ui.group;

import com.ap.d3.controller.D3Controller;
import com.ap.d3.fwk.model.IPath;
import com.ap.d3.fwk.model.ISchool;
import com.ap.d3.fwk.model.ISchoolLevel;
import com.ap.d3.fwk.model.ISpell;
import com.ap.d3.ui.D3View;
import com.ap.d3.ui.ESpellHierarchy;
import com.ap.d3.ui.content.spell.SpellTreeContentProvider;
import com.ap.d3.ui.content.spell.SpellTreeFilter;
import com.ap.d3.ui.content.spell.SpellTreeLabelProvider;
import com.ap.d3.ui.content.spell.SpellTreeModel;
import com.ap.d3.ui.content.spell.SpellTreeModelPath;
import com.ap.d3.ui.content.spell.SpellTreeModelRoot;
import com.ap.d3.ui.content.spell.SpellTreeModelSchool;
import com.ap.d3.ui.content.spell.SpellTreeModelSchoolLevel;
import com.ap.d3.ui.content.spell.SpellTreeModelSorter;
import com.ap.d3.ui.content.spell.SpellTreeModelSpell;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

public class GroupSpellList {
    private Group _groupSpells;
    private Combo _comboDisplay;
    private TreeViewer _treeViewer;
    private SpellTreeFilter _filter;

    public GroupSpellList(Composite parent, int hSpan, int vSpan) {
        this._groupSpells = new Group(parent, 0);
        Label label = new Label(this._groupSpells, 0);
        label.setLayoutData(new GridData(4, 0x1000000, false, false));
        label.setText("Choose display hierarchy:");
        this._comboDisplay = new Combo(this._groupSpells, -1);
        ESpellHierarchy[] eSpellHierarchyArray = ESpellHierarchy.values();
        int n = eSpellHierarchyArray.length;
        int n2 = 0;
        while (n2 < n) {
            ESpellHierarchy spellHier = eSpellHierarchyArray[n2];
            this._comboDisplay.add(spellHier.getName());
            ++n2;
        }
        this._comboDisplay.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int comboIdx = GroupSpellList.this._comboDisplay.getSelectionIndex();
                if (comboIdx != -1) {
                    String newHierarchy = GroupSpellList.this._comboDisplay.getItem(comboIdx);
                    D3View.getInstance().changeSpellHierarchy(newHierarchy);
                }
            }
        });
        this._comboDisplay.setVisible(true);
        this._comboDisplay.select(0);
        this._comboDisplay.setLayoutData(new GridData(4, 0x1000000, false, false));
        this._treeViewer = new TreeViewer(this._groupSpells, 2816);
        this._treeViewer.getControl().setLayoutData(new GridData(4, 4, true, true, 2, 1));
        this._treeViewer.setContentProvider(new SpellTreeContentProvider());
        this._treeViewer.setLabelProvider(new SpellTreeLabelProvider());
        this._treeViewer.setSorter(new SpellTreeModelSorter());
        this._groupSpells.setText("Spells");
        this._groupSpells.setFont(D3View.FONT_TAHOMA_10_BOLD);
        GridLayout gridLayout = new GridLayout(2, false);
        this._groupSpells.setLayout(gridLayout);
        GridData gridData = new GridData(4, 4, true, true, hSpan, vSpan);
        this._groupSpells.setLayoutData(gridData);
        this._filter = new SpellTreeFilter();
        this._treeViewer.addFilter(this._filter);
        this.hookListeners();
        D3View.getInstance().registerGroupSpellList(this);
        D3View.getInstance().changeSpellHierarchy(null);
    }

    public void updateFilters() {
        this._treeViewer.removeFilter(this._filter);
        this._treeViewer.addFilter(this._filter);
    }

    public void updateHierarchy() {
        this._treeViewer.setInput(this.getTreeInput());
        this._groupSpells.update();
        this._treeViewer.expandToLevel(1);
    }

    private SpellTreeModel getTreeInput() {
        SpellTreeModelRoot stmRoot = new SpellTreeModelRoot();
        switch (D3View.getInstance().getSpellHierarchy()) {
            case SPELL_HIER_SCHOOL: {
                ISchool[] iSchoolArray = D3Controller.getInstance().getGrimoire().getSchools();
                int n = iSchoolArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ISchool school = iSchoolArray[n2];
                    SpellTreeModelSchool stmSchool = stmRoot.newChild(school);
                    ISpell[] iSpellArray = D3Controller.getInstance().getGrimoire().getSpellsBySchool(school.getId());
                    int n3 = iSpellArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ISpell spell = iSpellArray[n4];
                        stmSchool.newChild(spell);
                        ++n4;
                    }
                    ++n2;
                }
                break;
            }
            case SPELL_HIER_LEVEL: {
                ISchool[] iSchoolArray = D3Controller.getInstance().getGrimoire().getSchools();
                int n = iSchoolArray.length;
                int n5 = 0;
                while (n5 < n) {
                    ISchool school = iSchoolArray[n5];
                    SpellTreeModelSchool stmSchool = stmRoot.newChild(school);
                    ISchoolLevel[] iSchoolLevelArray = D3Controller.getInstance().getGrimoire().getLevelBySchools(school.getId());
                    int n6 = iSchoolLevelArray.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        ISchoolLevel schoolLevel = iSchoolLevelArray[n7];
                        SpellTreeModelSchoolLevel stmSchoolLevel = stmSchool.newChild(schoolLevel);
                        ISpell[] iSpellArray = D3Controller.getInstance().getGrimoire().getSpellsBySchoolLevel(schoolLevel.getId());
                        int n8 = iSpellArray.length;
                        int n9 = 0;
                        while (n9 < n8) {
                            ISpell spell = iSpellArray[n9];
                            stmSchoolLevel.newChild(spell);
                            ++n9;
                        }
                        ++n7;
                    }
                    ++n5;
                }
                break;
            }
            case SPELL_HIER_PATH: {
                IPath[] iPathArray = D3Controller.getInstance().getGrimoire().getPaths();
                int n = iPathArray.length;
                int n10 = 0;
                while (n10 < n) {
                    IPath magicPath = iPathArray[n10];
                    SpellTreeModelPath stmPath = stmRoot.newChild(magicPath);
                    ISpell[] iSpellArray = D3Controller.getInstance().getGrimoire().getSpellsByPath(magicPath.getId());
                    int n11 = iSpellArray.length;
                    int n12 = 0;
                    while (n12 < n11) {
                        ISpell spell = iSpellArray[n12];
                        stmPath.newChild(spell);
                        ++n12;
                    }
                    ++n10;
                }
                break;
            }
            case SPELL_HIER_FLAT: {
                ISpell[] iSpellArray = D3Controller.getInstance().getGrimoire().getSpells();
                int n = iSpellArray.length;
                int n13 = 0;
                while (n13 < n) {
                    ISpell spell = iSpellArray[n13];
                    stmRoot.newChild(spell);
                    ++n13;
                }
                break;
            }
        }
        return stmRoot;
    }

    private void hookListeners() {
        this._treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                GroupSpellList.this._treeViewer.refresh();
                if (selection.isEmpty()) {
                    return;
                }
                if (selection instanceof TreeSelection) {
                    TreeSelection treeSelection = (TreeSelection)selection;
                    SpellTreeModel treeModel = (SpellTreeModel)treeSelection.getFirstElement();
                    if (treeModel instanceof SpellTreeModelSpell) {
                        SpellTreeModelSpell modelSpell = (SpellTreeModelSpell)treeModel;
                        D3View.getInstance().notifySpellSelection(modelSpell.getSpell());
                    } else {
                        D3View.getInstance().notifySpellSelection(null);
                    }
                }
            }
        });
    }
}

