/*
 * Decompiled with CFR 0.152.
 */
package com.ap.d3.controller.magic;

import com.ap.d3.fwk.controller.IGrimoire;
import com.ap.d3.model.magic.Effect;
import com.ap.d3.model.magic.Item;
import com.ap.d3.model.magic.ItemCategory;
import com.ap.d3.model.magic.ItemType;
import com.ap.d3.model.magic.Path;
import com.ap.d3.model.magic.School;
import com.ap.d3.model.magic.SchoolLevel;
import com.ap.d3.model.magic.Spell;
import com.ap.d3.model.magic.SpellType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Grimoire
implements IGrimoire {
    private static Grimoire _grimoire;
    private List<String> _listPaths;
    private Map<String, Path> _mapPath;
    private List<String> _listSchool;
    private Map<String, School> _mapSchool;
    private List<String> _listLevels;
    private Map<String, SchoolLevel> _mapLevel;
    private List<String> _listEffects;
    private Map<String, Effect> _mapEffect;
    private List<String> _listSpellTypes;
    private Map<String, SpellType> _mapSpellType;
    private List<String> _listSpells;
    private Map<String, Spell> _mapSpell;
    private List<String> _listItemTypes;
    private Map<String, ItemType> _mapItemType;
    private List<String> _listItemCategories;
    private Map<String, ItemCategory> _mapItemCategory;
    private List<String> _listItems;
    private Map<String, Item> _mapItem;
    private Map<String, List<String>> _mapSchool2SchoolLevel;
    private Map<String, List<String>> _mapType2Spell;
    private Map<String, List<String>> _mapPath2Spell;
    private Map<String, List<String>> _mapSchoolLevel2Spell;
    private Map<String, List<String>> _mapType2Item;
    private Map<String, List<String>> _mapCategory2Item;

    public static Grimoire getGrimoire() {
        if (_grimoire == null) {
            _grimoire = new Grimoire();
        }
        return _grimoire;
    }

    private Grimoire() {
        this.init();
    }

    public Path getPath(String id) {
        return this._mapPath.get(id);
    }

    public int getPathPosition(String id) {
        return this._listPaths.indexOf(id);
    }

    public Path[] getPaths() {
        Path[] result = new Path[this._listPaths.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this._mapPath.get(this._listPaths.get(i));
            ++i;
        }
        return result;
    }

    public School getSchool(String id) {
        return this._mapSchool.get(id);
    }

    public int getSchoolPosition(String id) {
        return this._listSchool.indexOf(id);
    }

    public School[] getSchools() {
        School[] result = new School[this._listSchool.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this._mapSchool.get(this._listSchool.get(i));
            ++i;
        }
        return result;
    }

    public SchoolLevel getSchoolLevel(String id) {
        return this._mapLevel.get(id);
    }

    public int getSchoolLevelPosition(String id) {
        return this._listLevels.indexOf(id);
    }

    public Effect getEffect(String id) {
        return this._mapEffect.get(id);
    }

    public int getEffectPosition(String id) {
        return this._listEffects.indexOf(id);
    }

    public Effect[] getEffects() {
        Effect[] result = new Effect[this._listEffects.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this._mapEffect.get(this._listEffects.get(i));
            ++i;
        }
        return result;
    }

    public SpellType getSpellType(String id) {
        return this._mapSpellType.get(id);
    }

    public int getSpellTypePosition(String id) {
        return this._listSpellTypes.indexOf(id);
    }

    public SpellType[] getSpellTypes() {
        SpellType[] result = new SpellType[this._listSpellTypes.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this._mapSpellType.get(this._listSpellTypes.get(i));
            ++i;
        }
        return result;
    }

    public Spell getSpell(String id) {
        return this._mapSpell.get(id);
    }

    public int getSpellPosition(String id) {
        return this._listSpells.indexOf(id);
    }

    public Spell[] getSpells() {
        Spell[] result = new Spell[this._listSpells.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this._mapSpell.get(this._listSpells.get(i));
            ++i;
        }
        return result;
    }

    public ItemType getItemType(String id) {
        return this._mapItemType.get(id);
    }

    public int getItemTypePosition(String id) {
        return this._listItemTypes.indexOf(id);
    }

    public ItemType[] getItemTypes() {
        ItemType[] result = new ItemType[this._listItemTypes.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this._mapItemType.get(this._listItemTypes.get(i));
            ++i;
        }
        return result;
    }

    public ItemCategory getItemCategory(String id) {
        return this._mapItemCategory.get(id);
    }

    public int getItemCategoryPosition(String id) {
        return this._listItemCategories.indexOf(id);
    }

    public ItemCategory[] getItemCategories() {
        ItemCategory[] result = new ItemCategory[this._listItemCategories.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this._mapItemCategory.get(this._listItemCategories.get(i));
            ++i;
        }
        return result;
    }

    public Item getItem(String id) {
        return this._mapItem.get(id);
    }

    public int getItemPosition(String id) {
        return this._listItems.indexOf(id);
    }

    public Item[] getItems() {
        Item[] result = new Item[this._listItems.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this._mapItem.get(this._listItems.get(i));
            ++i;
        }
        return result;
    }

    public SchoolLevel[] getLevelBySchools(String id) {
        List<String> tmpResult = this._mapSchool2SchoolLevel.get(id);
        SchoolLevel[] result = new SchoolLevel[tmpResult.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this._mapLevel.get(tmpResult.get(i));
            ++i;
        }
        return result;
    }

    public Spell[] getSpellsByType(String id) {
        List<String> tmpResult = this._mapType2Spell.get(id);
        Spell[] result = new Spell[tmpResult.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this._mapSpell.get(tmpResult.get(i));
            ++i;
        }
        return result;
    }

    public Spell[] getSpellsBySchool(String id) {
        ArrayList tmpResult = new ArrayList();
        SchoolLevel[] schoolLevelArray = this.getLevelBySchools(id);
        int n = schoolLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            SchoolLevel magicSchoolLevel = schoolLevelArray[n2];
            tmpResult.addAll(this._mapSchoolLevel2Spell.get(magicSchoolLevel.getId()));
            ++n2;
        }
        Spell[] result = new Spell[tmpResult.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this._mapSpell.get(tmpResult.get(i));
            ++i;
        }
        return result;
    }

    public Spell[] getSpellsBySchoolLevel(String id) {
        List<String> tmpResult = this._mapSchoolLevel2Spell.get(id);
        Spell[] result = new Spell[tmpResult.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this._mapSpell.get(tmpResult.get(i));
            ++i;
        }
        return result;
    }

    public Spell[] getSpellsByPath(String id) {
        List<String> tmpResult = this._mapPath2Spell.get(id);
        Spell[] result = new Spell[tmpResult.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this._mapSpell.get(tmpResult.get(i));
            ++i;
        }
        return result;
    }

    public Item[] getItemByType(String id) {
        List<String> tmpResult = this._mapType2Item.get(id);
        Item[] result = new Item[tmpResult.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this._mapItem.get(tmpResult.get(i));
            ++i;
        }
        return result;
    }

    public Item[] getItemByCategory(String id) {
        List<String> tmpResult = this._mapCategory2Item.get(id);
        Item[] result = new Item[tmpResult.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this._mapItem.get(tmpResult.get(i));
            ++i;
        }
        return result;
    }

    public void addPath(Path path, boolean overwrite) {
        if (this._listPaths.contains(path.getId())) {
            if (!overwrite) {
                return;
            }
        } else {
            this._listPaths.add(path.getId());
            this._mapPath2Spell.put(path.getId(), new ArrayList());
        }
        this._mapPath.put(path.getId(), path);
    }

    public void removePath(String id) {
        if (this._listPaths.remove(id)) {
            this._mapPath.remove(id);
            this._mapPath2Spell.remove(id);
        }
    }

    public void addSchool(School school, boolean overwrite) {
        if (this._listSchool.contains(school.getId())) {
            if (!overwrite) {
                return;
            }
        } else {
            this._listSchool.add(school.getId());
        }
        this._mapSchool.put(school.getId(), school);
        this._mapSchool2SchoolLevel.put(school.getId(), new ArrayList());
    }

    public void removeSchool(String id) {
        if (this._listSchool.remove(id)) {
            this._mapSchool.remove(id);
            this._mapSchool2SchoolLevel.remove(id);
        }
    }

    public void addSchoolLevel(SchoolLevel schoolLevel, boolean overwrite) {
        if (this._listLevels.contains(schoolLevel.getId())) {
            if (!overwrite) {
                return;
            }
        } else {
            this._listLevels.add(schoolLevel.getId());
            this._mapSchoolLevel2Spell.put(schoolLevel.getId(), new ArrayList());
        }
        this._mapLevel.put(schoolLevel.getId(), schoolLevel);
        this._mapSchool2SchoolLevel.get(schoolLevel.getSchool().getId()).add(schoolLevel.getId());
    }

    public void removeSchoolLevel(String id) {
        if (this._listLevels.remove(id)) {
            SchoolLevel level = this._mapLevel.remove(id);
            this._mapSchool2SchoolLevel.get(level.getSchool().getId()).remove(id);
            this._mapSchoolLevel2Spell.remove(id);
        }
    }

    public void addEffect(Effect effect, boolean overwrite) {
        if (this._listEffects.contains(effect.getId())) {
            if (!overwrite) {
                return;
            }
        } else {
            this._listEffects.add(effect.getId());
        }
        this._mapEffect.put(effect.getId(), effect);
    }

    public void removeEffect(String id) {
        if (this._listEffects.remove(id)) {
            this._mapEffect.remove(id);
        }
    }

    public void addSpellType(SpellType spellType, boolean overwrite) {
        if (this._listSpellTypes.contains(spellType.getId())) {
            if (!overwrite) {
                return;
            }
        } else {
            this._listSpellTypes.add(spellType.getId());
            this._mapType2Spell.put(spellType.getId(), new ArrayList());
        }
        this._mapSpellType.put(spellType.getId(), spellType);
    }

    public void removeSpellType(String id) {
        if (this._listSpellTypes.remove(id)) {
            this._mapSpellType.remove(id);
            this._mapType2Spell.remove(id);
        }
    }

    public void addSpell(Spell spell, boolean overwrite) {
        if (this._listSpells.contains(spell.getId())) {
            if (!overwrite) {
                return;
            }
        } else {
            this._listSpells.add(spell.getId());
        }
        this._mapSpell.put(spell.getId(), spell);
        this._mapPath2Spell.get(spell.getPrimaryPath().getId()).add(spell.getId());
        if (spell.hasSchool()) {
            this._mapSchoolLevel2Spell.get(spell.getSchoolLevel().getId()).add(spell.getId());
        } else {
            this._mapSchoolLevel2Spell.get("none").add(spell.getId());
        }
    }

    public void removeSpell(String id) {
        if (this._listSpells.remove(id)) {
            Spell spell = this._mapSpell.remove(id);
            this._mapPath2Spell.get(spell.getPrimaryPath().getId()).remove(id);
            this._mapSchoolLevel2Spell.get(spell.getSchoolLevel().getId()).remove(id);
        }
    }

    public void addItemType(ItemType itemType, boolean overwrite) {
        if (this._listItemTypes.contains(itemType.getId())) {
            if (!overwrite) {
                return;
            }
        } else {
            this._listItemTypes.add(itemType.getId());
            this._mapType2Item.put(itemType.getId(), new ArrayList());
        }
        this._mapItemType.put(itemType.getId(), itemType);
    }

    public void removeItemType(String id) {
        if (this._listItemTypes.remove(id)) {
            this._mapItemType.remove(id);
            this._mapType2Item.remove(id);
        }
    }

    public void addItemCategory(ItemCategory itemCategory, boolean overwrite) {
        if (this._listItemCategories.contains(itemCategory.getId())) {
            if (!overwrite) {
                return;
            }
        } else {
            this._listItemCategories.add(itemCategory.getId());
            this._mapCategory2Item.put(itemCategory.getId(), new ArrayList());
        }
        this._mapItemCategory.put(itemCategory.getId(), itemCategory);
    }

    public void removeItemCategory(String id) {
        if (this._listItemCategories.remove(id)) {
            this._mapItemCategory.remove(id);
            this._mapCategory2Item.remove(id);
        }
    }

    public void addItem(Item item, boolean overwrite) {
        if (this._listItems.contains(item.getId())) {
            if (!overwrite) {
                return;
            }
        } else {
            this._listItems.add(item.getId());
        }
        this._mapItem.put(item.getId(), item);
        this._mapType2Item.get(item.getType().getId()).add(item.getId());
        this._mapCategory2Item.get(item.getCategory().getId()).add(item.getId());
    }

    public void removeItem(String id) {
        if (this._listItems.remove(id)) {
            Item item = this._mapItem.remove(id);
            this._mapType2Item.get(item.getType().getId()).remove(item.getId());
            this._mapCategory2Item.get(item.getCategory().getId()).remove(item.getId());
        }
    }

    private void init() {
        this._listPaths = new ArrayList<String>();
        this._mapPath = new HashMap<String, Path>();
        this._listSchool = new ArrayList<String>();
        this._mapSchool = new HashMap<String, School>();
        this._listLevels = new ArrayList<String>();
        this._mapLevel = new HashMap<String, SchoolLevel>();
        this._listEffects = new ArrayList<String>();
        this._mapEffect = new HashMap<String, Effect>();
        this._listSpellTypes = new ArrayList<String>();
        this._mapSpellType = new HashMap<String, SpellType>();
        this._listSpells = new ArrayList<String>();
        this._mapSpell = new HashMap<String, Spell>();
        this._listItemTypes = new ArrayList<String>();
        this._mapItemType = new HashMap<String, ItemType>();
        this._listItemCategories = new ArrayList<String>();
        this._mapItemCategory = new HashMap<String, ItemCategory>();
        this._listItems = new ArrayList<String>();
        this._mapItem = new HashMap<String, Item>();
        this._mapSchool2SchoolLevel = new HashMap<String, List<String>>();
        this._mapType2Spell = new HashMap<String, List<String>>();
        this._mapPath2Spell = new HashMap<String, List<String>>();
        this._mapSchoolLevel2Spell = new HashMap<String, List<String>>();
        this._mapType2Item = new HashMap<String, List<String>>();
        this._mapCategory2Item = new HashMap<String, List<String>>();
        this._mapSchoolLevel2Spell.put("none", new ArrayList());
    }
}

