/*
 * Decompiled with CFR 0.152.
 */
package com.ap.d3.model.magic;

import com.ap.d3.controller.D3Controller;
import com.ap.d3.controller.exception.D3Exception;
import com.ap.d3.controller.magic.Grimoire;
import com.ap.d3.fwk.model.IPath;
import com.ap.d3.model.magic.Path;
import com.ap.d3.model.magic.PathLevel;
import com.ap.tools.string.StringHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Magics {
    private Map<String, PathLevel> _mapLevels;
    private Set<String> _listPaths;
    private boolean _bSorted;

    public static PathLevel getPathFromString(String s) throws D3Exception {
        Path path = Grimoire.getGrimoire().getPath(s.substring(0, 1));
        int value = new Integer(s.substring(1));
        return new PathLevel(path, value);
    }

    private static String[] getFirstPath(String s) {
        String[] result = new String[2];
        int i = 1;
        while (i < s.length() && StringHelper.isNumericChar(s.charAt(i))) {
            ++i;
        }
        result[0] = s.substring(0, i);
        result[1] = s.substring(i);
        return result;
    }

    private Magics(boolean b) {
        this._bSorted = b;
        this._mapLevels = new HashMap<String, PathLevel>();
        IPath[] iPathArray = D3Controller.getInstance().getGrimoire().getPaths();
        int n = iPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            this._mapLevels.put(path.getId(), new PathLevel(path, 0));
            ++n2;
        }
        this._listPaths = new HashSet<String>();
    }

    public String getId() {
        StringBuffer result = new StringBuffer();
        if (this._bSorted) {
            for (String pathId : this._listPaths) {
                result.append(this._mapLevels.get(pathId).getId());
            }
        } else {
            IPath[] iPathArray = D3Controller.getInstance().getGrimoire().getPaths();
            int n = iPathArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPath path = iPathArray[n2];
                PathLevel level = this._mapLevels.get(path.getId());
                if (this.containsPath(path.getId())) {
                    result.append(level.getId());
                }
                ++n2;
            }
        }
        return result.toString();
    }

    public int countPaths() {
        return this._listPaths.size();
    }

    public void upPath(String pathId) {
        PathLevel currentLevel = this._mapLevels.get(pathId);
        if (this.containsPath(pathId)) {
            currentLevel.setLevel(currentLevel.getLevel() + 1);
        } else {
            IPath path = D3Controller.getInstance().getGrimoire().getPath(pathId);
            this.setPathLevel(new PathLevel(path, 1));
        }
    }

    public void downPath(String pathId) {
        PathLevel currentLevel = this._mapLevels.get(pathId);
        if (currentLevel != null) {
            if (currentLevel.getLevel() == 1) {
                this.removePath(pathId);
            } else if (currentLevel.getLevel() > 0) {
                currentLevel.setLevel(currentLevel.getLevel() - 1);
            }
        }
    }

    public PathLevel getPathLevel(String pathId) {
        return this._mapLevels.get(pathId);
    }

    public void setPathLevel(PathLevel pathLevel) {
        String pathId = pathLevel.getPath().getId();
        if (pathLevel.getLevel() == 0) {
            this.removePath(pathId);
            return;
        }
        if (!this.containsPath(pathId)) {
            this._listPaths.add(pathId);
        }
        this._mapLevels.put(pathId, pathLevel);
    }

    public PathLevel[] getNonNullPathLevels() {
        ArrayList<PathLevel> result = new ArrayList<PathLevel>();
        if (this._bSorted) {
            for (String pathId : this._listPaths) {
                result.add(this._mapLevels.get(pathId));
            }
        } else {
            IPath[] iPathArray = D3Controller.getInstance().getGrimoire().getPaths();
            int n = iPathArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPath path = iPathArray[n2];
                PathLevel level = this._mapLevels.get(path.getId());
                if (this.containsPath(path.getId())) {
                    result.add(level);
                }
                ++n2;
            }
        }
        return result.toArray(new PathLevel[result.size()]);
    }

    public boolean containsPath(String pathId) {
        return this._listPaths.contains(pathId);
    }

    public boolean containsPathLevel(PathLevel level) {
        return this._mapLevels.get(level.getPath().getId()).getLevel() >= level.getLevel();
    }

    private void removePath(String pathId) {
        this._listPaths.remove(pathId);
        this._mapLevels.put(pathId, new PathLevel(D3Controller.getInstance().getGrimoire().getPath(pathId), 0));
    }

    /* synthetic */ Magics(boolean bl, Magics magics) {
        this(bl);
    }

    public static class Factory {
        public static Magics getEmptyMagics() {
            return new Magics(false, null);
        }

        public static Magics getMagics(String s, boolean b) throws D3Exception {
            Magics result = new Magics(b, null);
            String tmp = s;
            while (tmp != null && !tmp.equals("")) {
                String[] path = Magics.getFirstPath(tmp);
                PathLevel pathLevel = Magics.getPathFromString(path[0]);
                if (result.containsPath(pathLevel.getPath().getId())) {
                    throw D3Exception.getInvalidMagicLevelDuplicatePath(s);
                }
                result.setPathLevel(pathLevel);
                tmp = path[1];
            }
            return result;
        }
    }
}

