/*
 * Decompiled with CFR 0.152.
 */
package com.ap.d3.ui.composite;

import com.ap.d3.controller.D3Controller;
import com.ap.tools.image.D3ImageCache;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class CompositePathLevel {
    private Composite _composite;
    private Label[] _labels;
    private int _iMaxChild;
    private Image _image;

    public CompositePathLevel(Composite parent, String pathId, int nbChild) {
        this._composite = new Composite(parent, 16);
        GridLayout gridLayoutGems = new GridLayout(nbChild, false);
        gridLayoutGems.marginBottom = 0;
        gridLayoutGems.marginHeight = 0;
        gridLayoutGems.marginLeft = 0;
        gridLayoutGems.marginRight = 0;
        gridLayoutGems.marginTop = 0;
        gridLayoutGems.marginWidth = 0;
        this._composite.setLayout(gridLayoutGems);
        this._composite.setLayoutData(new GridData(4, 0x1000000, true, false));
        this._iMaxChild = nbChild;
        this._image = D3ImageCache.getInstance().getImagePath(D3Controller.getInstance().getGrimoire().getPath(pathId), 16);
        this._labels = new Label[this._iMaxChild];
        int i = 0;
        while (i < this._iMaxChild) {
            this._labels[i] = new Label(this._composite, 0);
            this._labels[i].setLayoutData(new GridData(16384, 0x1000000, false, false));
            ++i;
        }
    }

    public void reset() {
        int i = 0;
        while (i < this._labels.length) {
            this.resetLabel(this._labels[i]);
            ++i;
        }
        this._composite.pack();
    }

    public void update(int value) {
        if (value == 0) {
            this.reset();
            return;
        }
        int i = 0;
        while (i < this._iMaxChild) {
            if (i < value) {
                this.displayLabel(this._labels[i]);
            } else {
                this.resetLabel(this._labels[i]);
            }
            ++i;
        }
        this._composite.pack();
    }

    private void resetLabel(Label l) {
        l.setText("");
        l.setImage(null);
        l.update();
    }

    private void displayLabel(Label l) {
        l.setText("");
        l.setImage(this._image);
        l.update();
    }
}

