/*
 * Decompiled with CFR 0.152.
 */
package com.ap.d3.ui.group;

import com.ap.d3.controller.D3Controller;
import com.ap.d3.fwk.model.IPath;
import com.ap.d3.model.magic.Magics;
import com.ap.d3.ui.D3View;
import com.ap.d3.ui.actions.Action;
import com.ap.d3.ui.actions.IActionReceiver;
import com.ap.d3.ui.composite.CompositeButtonUpDown;
import com.ap.d3.ui.composite.CompositePathLevel;
import com.ap.tools.image.D3ImageCache;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

public class GroupPath
implements IActionReceiver {
    private Group _groupPaths;
    private Map<String, CompositePathLevel> _mapPath2Labels;
    private Magics _magics;

    public GroupPath(Composite parent, int hSpan, int vSpan) {
        this._groupPaths = new Group(parent, 0);
        this._groupPaths.setText("Magic Path");
        this._groupPaths.setFont(D3View.FONT_TAHOMA_10_BOLD);
        this._groupPaths.setLayout(new GridLayout(3, false));
        this._groupPaths.setLayoutData(new GridData(4, 4, true, false, hSpan, vSpan));
        this._magics = Magics.Factory.getEmptyMagics();
        this._mapPath2Labels = new HashMap<String, CompositePathLevel>();
        IPath[] iPathArray = D3Controller.getInstance().getGrimoire().getPaths();
        int n = iPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            String pathId = path.getId();
            new CompositeButtonUpDown(this._groupPaths, this, pathId, 10);
            Label label = new Label(this._groupPaths, 2048);
            label.setLayoutData(new GridData(16384, 0x1000000, false, false));
            label.setImage(D3ImageCache.getInstance().getImagePathPic(path));
            CompositePathLevel cpp = new CompositePathLevel(this._groupPaths, pathId, 12);
            this._mapPath2Labels.put(pathId, cpp);
            ++n2;
        }
    }

    public void act(Action action, String s) {
        if (action.equals((Object)Action.ACTION_PLUS)) {
            if (this._magics.getPathLevel(s).getLevel() < 12) {
                this._magics.upPath(s);
                this.update(s);
            }
        } else if (action.equals((Object)Action.ACTION_MINUS)) {
            this._magics.downPath(s);
            this.update(s);
        }
    }

    private void update(String pathId) {
        CompositePathLevel cpp = this._mapPath2Labels.get(pathId);
        cpp.update(this._magics.getPathLevel(pathId).getLevel());
        D3View.getInstance().changePathFilter(this._magics);
    }
}

