/*
 * Decompiled with CFR 0.152.
 */
package com.ap.tools.image;

import com.ap.d3.D3Project;
import com.ap.d3.fwk.model.IItem;
import com.ap.d3.fwk.model.IItemCategory;
import com.ap.d3.fwk.model.IItemType;
import com.ap.d3.fwk.model.IPath;
import com.ap.d3.fwk.model.IPathLevel;
import com.ap.d3.fwk.model.ISchool;
import com.ap.d3.fwk.model.ISchoolLevel;
import com.ap.tools.image.ImageIdentifier;
import com.ap.tools.image.ImageSymbol;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class D3ImageCache {
    private static final String TYPE_GIF = "GIF";
    private static final String TYPE_PNG = "PNG";
    private static final String PATH_IMAGE_PATH = "/resources/pics/paths/";
    private static final String PATH_IMAGE_SCHOOLS = "/resources/pics/schools/";
    private static final String PATH_IMAGE_ITEM = "/resources/pics/items/";
    private static final String PATH_IMAGE_ITEMTYPE = "/resources/pics/item_types/";
    private static final String PATH_IMAGE_ITEMCAT = "/resources/pics/item_cats/";
    private static final String PATH_IMAGE_GEM = "/resources/pics/gems/";
    private static final String PATH_IMAGE_UI = "/resources/pics/ui/";
    private static D3ImageCache _instance;
    private Map<ImageIdentifier, Image> _mapImage = new HashMap<ImageIdentifier, Image>();

    private D3ImageCache() {
    }

    public static D3ImageCache getInstance() {
        if (_instance == null) {
            _instance = new D3ImageCache();
        }
        return _instance;
    }

    public Image getImageUI(String name) {
        return this.getBaseImage(ImageIdentifier.Factory.getBaseImageId(PATH_IMAGE_UI + name, TYPE_PNG));
    }

    public Image getImageSchool(ISchool school) {
        return this.getBaseImage(ImageIdentifier.Factory.getBaseImageId(PATH_IMAGE_SCHOOLS + school.getId(), TYPE_PNG));
    }

    public Image getImageSchoolLevel(ISchoolLevel level) {
        return this.getBaseImage(ImageIdentifier.Factory.getBaseImageId(PATH_IMAGE_SCHOOLS + level.getId().charAt(level.getId().length() - 1), TYPE_PNG));
    }

    public Image getImageItemType(IItemType type) {
        return this.getBaseImage(ImageIdentifier.Factory.getBaseImageId(PATH_IMAGE_ITEMTYPE + type.getId(), TYPE_PNG));
    }

    public Image getImageItemCategory(IItemCategory category) {
        return this.getBaseImage(ImageIdentifier.Factory.getBaseImageId(PATH_IMAGE_ITEMCAT + category.getId(), TYPE_PNG));
    }

    public Image getImageItem(IItem item, int size) {
        return this.getResizedImage(ImageIdentifier.Factory.getResizedImageId(PATH_IMAGE_ITEM + item.getId(), size, TYPE_PNG));
    }

    public Image getImageGem(IPath path) {
        return this.getResizedImage(ImageIdentifier.Factory.getResizedImageId(PATH_IMAGE_GEM + path.getId(), 14, TYPE_PNG));
    }

    public Image getImagePath(IPath path, int size) {
        return this.getResizedImage(ImageIdentifier.Factory.getResizedImageId(PATH_IMAGE_PATH + path.getId() + "_ori", size, TYPE_PNG));
    }

    public Image getImagePathPic(IPath path) {
        return this.getBaseImage(ImageIdentifier.Factory.getBaseImageId(PATH_IMAGE_PATH + path.getId(), TYPE_GIF));
    }

    public Image getImagePathNumbered(IPathLevel pathLevel) {
        ImageIdentifier id = ImageIdentifier.Factory.getTatooedImageId(PATH_IMAGE_PATH + pathLevel.getPath().getId(), pathLevel.getId(), TYPE_PNG);
        if (this._mapImage.get(id) == null) {
            ImageData data = this.getBaseImage(ImageIdentifier.Factory.getBaseImageId(id.getBaseImageName(), id.getType())).getImageData();
            ImageSymbol.drawSymbol(data, ImageSymbol.getSmallNumberSymbol(pathLevel.getLevel()), 13, 11);
            this._mapImage.put(id, new Image((Device)this.getDisplay(), data));
        }
        return this._mapImage.get(id);
    }

    public Image getImagePathNumbered(IPathLevel plPri, IPathLevel plSec) {
        String name = String.valueOf(plPri.getPath().getId()) + plSec.getPath().getId();
        ImageIdentifier id = ImageIdentifier.Factory.getTatooedImageId(PATH_IMAGE_PATH + name, String.valueOf(plPri.getId()) + plSec.getId(), TYPE_PNG);
        if (this._mapImage.get(id) == null) {
            ImageData data = this.getBaseImage(ImageIdentifier.Factory.getBaseImageId(id.getBaseImageName(), id.getType())).getImageData();
            ImageSymbol.drawSymbol(data, ImageSymbol.getSmallNumberSymbol(plPri.getLevel()), 5, 10);
            ImageSymbol.drawSymbol(data, ImageSymbol.getSmallNumberSymbol(plSec.getLevel()), 13, 10);
            this._mapImage.put(id, new Image((Device)this.getDisplay(), data));
        }
        return this._mapImage.get(id);
    }

    private String getPath(String sRelPath) {
        return D3Project.getInstance().getFileLoader().getAbsolutePath(sRelPath);
    }

    private Display getDisplay() {
        return D3Project.getInstance().getFileLoader().getDisplay();
    }

    private Image getResizedImage(ImageIdentifier id) {
        if (this._mapImage.get(id) == null) {
            ImageIdentifier baseId = ImageIdentifier.Factory.getBaseImageId(id.getBaseImageName(), id.getType());
            ImageData data = this.getScaledImageDataMax(baseId, id.getSize());
            this._mapImage.put(id, new Image((Device)this.getDisplay(), data));
        }
        return this._mapImage.get(id);
    }

    private Image getBaseImage(ImageIdentifier id) {
        if (this._mapImage.get(id) == null) {
            try {
                String path = this.getPath(id.toString());
                ImageData data = new ImageData(new FileInputStream(path));
                this._mapImage.put(id, new Image((Device)this.getDisplay(), data));
            }
            catch (FileNotFoundException fnfEx) {
                System.out.println("Image: " + id.getBaseImageName() + " does not exists.");
            }
        }
        return this._mapImage.get(id);
    }

    private ImageData getScaledImageDataMax(ImageIdentifier id, int value) {
        ImageData data1 = this.getScaledImageDataHeight(id, value);
        if (data1.width <= value) {
            return data1;
        }
        return this.getScaledImageDataWidth(id, value);
    }

    private ImageData getScaledImageDataHeight(ImageIdentifier id, int h) {
        Image image = this.getBaseImage(id);
        if (image.getBounds().height == h) {
            return image.getImageData();
        }
        return this.getScaledImageData(image, image.getBounds().width * h / image.getBounds().height, h);
    }

    private ImageData getScaledImageDataWidth(ImageIdentifier id, int w) {
        Image image = this.getBaseImage(id);
        if (image.getBounds().width == w) {
            return image.getImageData();
        }
        return this.getScaledImageData(image, w, image.getBounds().height * w / image.getBounds().width);
    }

    private ImageData getScaledImageData(Image image, int w, int h) {
        ImageData data = image.getImageData().scaledTo(w, h);
        return data;
    }
}

