/*
 * Decompiled with CFR 0.152.
 */
package com.ap.d3.controller.exception;

public class D3Exception
extends Exception {
    private static final long serialVersionUID = 1L;
    private String _sId;
    private String _sMsg;

    public static D3Exception getUnknownTerrain(String id) {
        return new D3Exception("DOM300001", "Unknown terrain type: " + id);
    }

    public static D3Exception getUnknownMagicSite(String id) {
        return new D3Exception("DOM300011", "Unknown magic site: " + id);
    }

    public static D3Exception getInvalidMagicSite(String id, String province) {
        return new D3Exception("DOM300011", "Magic site '" + id + "' does not exists in province '" + province + "'");
    }

    public static D3Exception getUnknownBuildingAdmin(String id) {
        return new D3Exception("DOM300100", "Unknown administration building name: " + id);
    }

    public static D3Exception getUnknownBuildingReligious(String id) {
        return new D3Exception("DOM300101", "Unknown religious building name: " + id);
    }

    public static D3Exception getUnknownBuildingMagic(String id) {
        return new D3Exception("DOM300102", "Unknown magic building name: " + id);
    }

    public static D3Exception getInvalidMagicPath(String id) {
        return new D3Exception("DOM300200", "Invalid magic path: " + id);
    }

    public static D3Exception getInvalidMagicLevelDuplicatePath(String id) {
        return new D3Exception("DOM300201", "A complex magic path cannot contain the same path: " + id);
    }

    public static D3Exception getUnknownProvince(String id) {
        return new D3Exception("DOM300300", "Unknown province: " + id);
    }

    public static D3Exception getMapBaseLoadException(String id) {
        return new D3Exception("DOM300400", "Failed to load base map: " + id);
    }

    private D3Exception(String id, String msg) {
        this._sId = id;
        this._sMsg = msg;
    }

    public String getId() {
        return this._sId;
    }

    public String getMsg() {
        return this._sMsg;
    }
}

