/*
 * Decompiled with CFR 0.152.
 */
package com.ap.d3.ui.group;

import com.ap.d3.controller.D3Controller;
import com.ap.d3.fwk.model.IEffect;
import com.ap.d3.ui.D3View;
import com.ap.d3.ui.content.effect.EffectContentProvider;
import com.ap.d3.ui.content.effect.EffectLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public class GroupEffect {
    private Group _groupEffect;
    private ListViewer _listViewer1;
    private ListViewer _listViewer2;

    public GroupEffect(Composite parent, int hSpan, int vSpan) {
        this._groupEffect = new Group(parent, 0);
        this._listViewer1 = new ListViewer(this._groupEffect, 2816);
        this._listViewer1.getControl().setLayoutData(new GridData(4, 4, false, true, 1, 2));
        this._listViewer1.setContentProvider(new EffectContentProvider());
        this._listViewer1.setLabelProvider(new EffectLabelProvider());
        this._listViewer1.setInput(D3Controller.getInstance().getGrimoire().getEffects());
        Button _buttonGo = new Button(this._groupEffect, 8);
        _buttonGo.setLayoutData(new GridData(0x1000000, 1024, false, true));
        _buttonGo.setText(">");
        _buttonGo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GroupEffect.this.addEffect();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this._listViewer2 = new ListViewer(this._groupEffect, 2816);
        this._listViewer2.getControl().setLayoutData(new GridData(4, 4, false, true, 1, 2));
        this._listViewer2.setContentProvider(new EffectContentProvider());
        this._listViewer2.setLabelProvider(new EffectLabelProvider());
        this._listViewer2.setInput(null);
        Button _buttonBack = new Button(this._groupEffect, 8);
        _buttonBack.setLayoutData(new GridData(0x1000000, 128, false, true));
        _buttonBack.setText("<");
        _buttonBack.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GroupEffect.this.removeEffect();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this._groupEffect.setText("Effects");
        this._groupEffect.setFont(D3View.FONT_TAHOMA_10_BOLD);
        this._groupEffect.setLayout(new GridLayout(3, false));
        this._groupEffect.setLayoutData(new GridData(4, 4, true, true, hSpan, vSpan));
    }

    private void addEffect() {
        ISelection selection = this._listViewer1.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (selection instanceof StructuredSelection) {
            StructuredSelection strSelection = (StructuredSelection)selection;
            IEffect effect = (IEffect)strSelection.getFirstElement();
            this._listViewer2.add(effect);
            this._listViewer1.remove(effect);
            D3View.getInstance().changeEffectFilter(effect, true);
        }
    }

    private void removeEffect() {
        ISelection selection = this._listViewer2.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (selection instanceof StructuredSelection) {
            StructuredSelection strSelection = (StructuredSelection)selection;
            IEffect effect = (IEffect)strSelection.getFirstElement();
            this._listViewer1.add(strSelection.getFirstElement());
            this._listViewer2.remove(strSelection.getFirstElement());
            D3View.getInstance().changeEffectFilter(effect, false);
        }
    }
}

