/*
 * Decompiled with CFR 0.152.
 */
package com.ap.d3.ui.group;

import com.ap.d3.controller.D3Controller;
import com.ap.d3.fwk.model.IItem;
import com.ap.d3.fwk.model.IItemCategory;
import com.ap.d3.fwk.model.IItemType;
import com.ap.d3.ui.D3View;
import com.ap.d3.ui.EItemHierarchy;
import com.ap.d3.ui.content.item.ItemTreeContentProvider;
import com.ap.d3.ui.content.item.ItemTreeFilter;
import com.ap.d3.ui.content.item.ItemTreeLabelProvider;
import com.ap.d3.ui.content.item.ItemTreeModel;
import com.ap.d3.ui.content.item.ItemTreeModelCategory;
import com.ap.d3.ui.content.item.ItemTreeModelItem;
import com.ap.d3.ui.content.item.ItemTreeModelRoot;
import com.ap.d3.ui.content.item.ItemTreeModelSorter;
import com.ap.d3.ui.content.item.ItemTreeModelType;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

public class GroupItemList {
    private Group _groupItems;
    private Combo _comboDisplay;
    private TreeViewer _treeViewer;
    private ItemTreeFilter _filter;

    public GroupItemList(Composite parent, int hSpan, int vSpan) {
        this._groupItems = new Group(parent, 0);
        Label label = new Label(this._groupItems, 0);
        label.setLayoutData(new GridData(4, 0x1000000, false, false));
        label.setText("Choose display hierarchy:");
        this._comboDisplay = new Combo(this._groupItems, -1);
        EItemHierarchy[] eItemHierarchyArray = EItemHierarchy.values();
        int n = eItemHierarchyArray.length;
        int n2 = 0;
        while (n2 < n) {
            EItemHierarchy itemHier = eItemHierarchyArray[n2];
            this._comboDisplay.add(itemHier.getName());
            ++n2;
        }
        this._comboDisplay.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int comboIdx = GroupItemList.this._comboDisplay.getSelectionIndex();
                if (comboIdx != -1) {
                    String newHierarchy = GroupItemList.this._comboDisplay.getItem(comboIdx);
                    D3View.getInstance().changeItemHierarchy(newHierarchy);
                }
            }
        });
        this._comboDisplay.setVisible(true);
        this._comboDisplay.setLayoutData(new GridData(4, 0x1000000, false, false));
        this._comboDisplay.select(0);
        this._treeViewer = new TreeViewer(this._groupItems, 2816);
        this._treeViewer.getControl().setLayoutData(new GridData(4, 4, true, true, 2, 1));
        this._treeViewer.setContentProvider(new ItemTreeContentProvider());
        this._treeViewer.setLabelProvider(new ItemTreeLabelProvider());
        this._treeViewer.setSorter(new ItemTreeModelSorter());
        this._filter = new ItemTreeFilter();
        this._treeViewer.addFilter(this._filter);
        this._groupItems.setText("Items");
        this._groupItems.setFont(D3View.FONT_TAHOMA_10_BOLD);
        GridLayout gridLayout = new GridLayout(2, false);
        this._groupItems.setLayout(gridLayout);
        GridData gridData = new GridData(4, 4, true, true, hSpan, vSpan);
        this._groupItems.setLayoutData(gridData);
        this.hookListeners();
        D3View.getInstance().registerGroupItemList(this);
        D3View.getInstance().changeItemHierarchy(null);
    }

    public void updateHierarchy() {
        this._treeViewer.setInput(this.getTreeInput());
        this._groupItems.update();
        this._treeViewer.expandToLevel(1);
    }

    public void updateFilters() {
        this._treeViewer.removeFilter(this._filter);
        this._treeViewer.addFilter(this._filter);
    }

    private ItemTreeModel getTreeInput() {
        ItemTreeModelRoot itmRoot = new ItemTreeModelRoot();
        switch (D3View.getInstance().getItemHierarchy()) {
            case ITEM_HIER_CAT: {
                IItemCategory[] iItemCategoryArray = D3Controller.getInstance().getGrimoire().getItemCategories();
                int n = iItemCategoryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IItemCategory category = iItemCategoryArray[n2];
                    ItemTreeModelCategory itmCategory = itmRoot.newChild(category);
                    IItem[] iItemArray = D3Controller.getInstance().getGrimoire().getItemByCategory(category.getId());
                    int n3 = iItemArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IItem item = iItemArray[n4];
                        itmCategory.newChild(item);
                        ++n4;
                    }
                    ++n2;
                }
                break;
            }
            case ITEM_HIER_TYPE: {
                IItemType[] iItemTypeArray = D3Controller.getInstance().getGrimoire().getItemTypes();
                int n = iItemTypeArray.length;
                int n5 = 0;
                while (n5 < n) {
                    IItemType type = iItemTypeArray[n5];
                    ItemTreeModelType itmType = itmRoot.newChild(type);
                    IItem[] iItemArray = D3Controller.getInstance().getGrimoire().getItemByType(type.getId());
                    int n6 = iItemArray.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        IItem item = iItemArray[n7];
                        itmType.newChild(item);
                        ++n7;
                    }
                    ++n5;
                }
                break;
            }
            case ITEM_HIER_FLAT: {
                IItem[] iItemArray = D3Controller.getInstance().getGrimoire().getItems();
                int n = iItemArray.length;
                int n8 = 0;
                while (n8 < n) {
                    IItem item = iItemArray[n8];
                    itmRoot.newChild(item);
                    ++n8;
                }
                break;
            }
        }
        return itmRoot;
    }

    private void hookListeners() {
        this._treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                GroupItemList.this._treeViewer.refresh();
                if (selection.isEmpty()) {
                    return;
                }
                if (selection instanceof TreeSelection) {
                    TreeSelection treeSelection = (TreeSelection)selection;
                    ItemTreeModel treeModel = (ItemTreeModel)treeSelection.getFirstElement();
                    if (treeModel instanceof ItemTreeModelItem) {
                        ItemTreeModelItem itmItem = (ItemTreeModelItem)treeModel;
                        D3View.getInstance().notifyItemSelection(itmItem.getItem());
                    } else {
                        D3View.getInstance().notifyItemSelection(null);
                    }
                }
            }
        });
    }
}

