#modname "MA Aotearoa: Age of Whakapapa"
#description "Nation mod inspired by Australian Aborigine and pacific islander (mainly Maori) tradition and myth.  Descended from EA Alchera (Alchera is the Aboriginal world for the 'Dreamtime'), Aotearoa (the Maori word for the northern island of New Zealand) is more influenced by Maori myth and tradition than its ancestor."
#version 0.1
#domversion 3.23
#icon "./alchera/banner.tga"

-- Comments:
-- uses nation # 73, monster #s 2469-99, weapon #s 681-9, armor #s 281-5, site #s 881-3, and nametypes ??? (LA nations)
-- (should be) CBM compatible
-- special thanks to Lavarae for help with Maori myth and tradition, Foodstamp for the inspiration Haida Gwaii provided, Honeybadger and AplineJoe for input and encouragment, and sombre and burnsaber for l33t mod skillz ...did I say that right? I'm not fluent in l33t... :)

#newmonster 2469
#clear
#name "Aotearoa Militia"
#spr1 "./alchera/2009_1.tga"
#spr2 "./alchera/2009_2.tga"
#descr "Aotearoa's militia are the last line of defense for their villages, and lack the modern equipment and military discipline, but still possess the strength and hardiness of their people."
#ap 10
#mapmove 1
#hp 12
#size 2
#str 11
#enc 3
#att 9
#def 9
#prec 9
#mr 11
#mor 8
#gcost 6
#rcost 1
#maxage 60
#weapon "Spear"
#armor "Hide Shield"
#end

#newmonster 2470
#clear
#name "Aotearoa Warrior"
#spr1 "./alchera/2005_1.tga"
#spr2 "./alchera/2005_2.tga"
#descr "The Aotearoa inherited the physical hardiness of their Maohi ancestoes as well as a tenuous connection to the Dreamtime of their Alchera ancestors.  Warriors of Aotearoa wield the Patu Onewa, a paddle shaped stone club with thin, almost sharp, edges."
#ap 12
#mapmove 2
#hp 12
#size 2
#str 11
#enc 3
#att 10
#def 10
#prec 10
#mr 11
#mor 10
#gcost 11
#rcost 1
#weapon "Spear"
#weapon "Patu"
#armor "Leather Cuirass"
#maxage 60
#swampsurvival
#wastesurvival
#ambidextrous 3
#end

#newmonster 2471
#clear
#name "Aotearoa Javilineer"
#spr1 "./alchera/2006_1.tga"
#spr2 "./alchera/2006_2.tga"
#descr "The Aotearoa inherited the physical hardiness of their Maohi ancestoes as well as a tenuous connection to the Dreamtime of their Alchera ancestors.  Their javilineers use the Woomera, a wooden spear-thrower that doubles as a shield."
#ap 12
#mapmove 2
#hp 12
#size 2
#str 11
#enc 3
#att 10
#def 10
#prec 10
#mr 11
#mor 10
#gcost 11
#rcost 1
#weapon "Woomera"
#weapon "Spear"
#armor "Leather Cuirass"
#armor "Woomera Shield"
#maxage 60
#swampsurvival
#wastesurvival
#end

#newmonster 2472
#clear
#name "Aotearoa Heavy Infantry"
#spr1 "./alchera/2005_1.tga"
#spr2 "./alchera/2005_2.tga"
#descr "Trade has brought steel arms and armor to Aotearoa.  Though eschewing heavy plate armor, some Aotearoa Warriors have adopted the use of swords and chain mail.  Cultural disapproval of foreign arms makes these soldiers, though skilled, less confident in battle than their more traditional brethern."
#ap 12
#mapmove 2
#hp 12
#size 2
#str 11
#enc 3
#att 10
#def 10
#prec 10
#mr 11
#mor 9
#gcost 13
#rcost 1
#weapon "Broadsword"
#armor "Kite Shield"
#armor "Chain Mail Hauberk"
#armor "Half Helmet"
#maxage 60
#end

#newmonster 2473
#clear
#name "Possum Warrior"
#spr1 "./alchera/2003_1.tga"
#spr2 "./alchera/2003_2.tga"
#descr "Though fewer in number than in the days of old Alchera, the tradition of the Possum Warriors is still strong, and being chosen to wear one of the increasingly rare enchanted possumskin cloaks is a great honor."
#ap 12
#mapmove 2
#hp 13
#size 2
#str 11
#enc 3
#att 12
#def 12
#prec 10
#mr 13
#mor 13
#gcost 25
#rcost 1
#weapon "Machaka Spear"
#armor "Shield"
#armor "Possum-skin cloak"
#maxage 60
#wastesurvival
#end

#newmonster 2474
#clear
#name "Moko Tumatauegna"
#spr1 "./alchera/2005_1.tga"
#spr2 "./alchera/2005_2.tga"
#descr "Those with strong whakapapa and great courage often get te Moko, complex stylized tattoos on their face and body that announce their whakapapa to everyone who sees them.  Those whose whakapapa connects them to Tu wield the traditional spear and patu with frightening skill, and are very disciplined in battle. Moko warriors never cover their sacred tatoos with armor."
#ap 12
#mapmove 2
#hp 14
#size 2
#str 13
#enc 3
#att 13
#def 13
#prec 10
#mr 12
#mor 15
#gcost 20
#rcost 5
#weapon "Spear"
#weapon "Patu"
#maxage 60
#swampsurvival
#wastesurvival
#ambidextrous 4
#end

#newmonster 2475
#clear
#name "Moko Tanematahuta"
#spr1 "./alchera/2006_1.tga"
#spr2 "./alchera/2006_2.tga"
#descr "Those with strong whakapapa and great courage often get te Moko, complex stylized tattoos on their face and body that announce their whakapapa to everyone who sees them.  Those whose Whakapapa connects them to Tane are given the eyes of eages and resistance to poison.  Their battle-rage is terrifying.  Moko warriors never cover their sacred tatoos with armor."
#ap 12
#mapmove 2
#hp 12
#size 2
#str 11
#enc 3
#att 12
#def 12
#prec 16
#mr 12
#mor 13
#gcost 30
#rcost 5
#weapon "Woomera"
#weapon "Spear"
#armor "Woomera Shield"
#maxage 60
#swampsurvival
#wastesurvival
#poisonres 50
#berserk 3
#holy
#end

#newmonster 2476
#clear
#name "Moko Tangaroa"
#spr1 "./alchera/2007_1.tga"
#spr2 "./alchera/2007_2.tga"
#descr "The Aotearoa no longer dive for food, but the traditions of diving and breath control have been maintained, and Tangaroa has gifted those wearing his Moko with the speed of the eel and the abiliity to see in the lightless depths."
#ap 18
#mapmove 1
#hp 12
#size 2
#str 11
#enc 2
#att 12
#def 12
#prec 10
#mr 11
#mor 13
#gcost 30
#rcost 1
#weapon "Spear"
#weapon "Net"
#armor "Sharkstooth Necklace"
#maxage 60
#female
#amphibian
#coldres 60
#darkvision 50
#holy
#end

#newmonster 2480
#clear
#clearmagic
#name "Aotearoa Scout"
#nametype 126
#spr1 "./alchera/2102_1.tga"
#spr2 "./alchera/2102_2.tga"
#descr "The stealthy war-parties of old Alchera are gone, but a few individuals still recall the hunter's arts."
#ap 12
#mapmove 2
#hp 12
#size 2
#str 11
#enc 3
#att 10
#def 10
#prec 12
#mr 11
#mor 12
#gcost 20
#rcost 1
#weapon "Woomera"
#weapon "Spear"
#armor "Woomera Shield"
#maxage 60
#wastesurvival
#swampsurvival
#stealthy
#noleader
#end

#newmonster 2481
#clear
#clearmagic
#name "Wakataua Master"
#nametype 126
#spr1 "./alchera/2101_1.tga"
#spr2 "./alchera/2101_2.tga"
#descr "Aotearoa boatmasters who lead groups of raiders in seaworthy 'wakatauas' - war canoes."
#ap 12
#mapmove 2
#hp 14
#size 2
#str 13
#enc 3
#att 11
#def 11
#prec 11
#mr 10
#mor 11
#gcost 50
#rcost 20
#weapon "Spear"
#weapon "Woomera"
#armor "Woomera Shield"
#armor "Leather Cuirass"
#maxage 55
#swampsurvival
#sailing
#okleader
#end

#newmonster 2482
#clear
#clearmagic
#name "Rongo Tohunga"
#nametype 126
#spr1 "./alchera/2103_1.tga"
#spr2 "./alchera/2103_2.tga"
#descr "Minor priest of Ronga, spirit of agriculture and domesticated creatures, Rongo's Tohunga rarely go to war, instead maintaining the homefront.  About half of them have some skill with magic."
#ap 8
#mapmove 2
#hp 12
#size 2
#str 11
#enc 3
#att 9
#def 9
#prec 10
#mr 11
#mor 10
#gcost 60
#rcost 1
#weapon "Godstick"
#maxage 55
#poorleader
#holy
#magicskill 8 1
#custommagic 8192 50
#lucky 5
#end

#newmonster 2483
#clear
#clearmagic
#name "Devoted of Hinu-ne-po"
#nametype 126
#spr1 "./alchera/2103_1.tga"
#spr2 "./alchera/2103_2.tga"
#descr "Hinu-ne-po is recognized as the gurardian spirit of the dead in Aotearoa, but is not worshipped.  Nonetheless, some women devote themselves to her and learn the secrets of the grave from her."
#ap 8
#mapmove 2
#hp 12
#size 2
#str 11
#enc 3
#att 10
#def 10
#prec 12
#mr 11
#mor 14
#gcost 90
#rcost 1
#weapon "Dagger"
#maxage 55
#swampsurvival
#wastesurvival
#poorleader
#magicskill 5 1
#custommagic 4096 50
#end


#newmonster 2484
#clear
#clearmagic
#name "Tanematahuta Tohunga"
#nametype 126
#spr1 "./alchera/2103_1.tga"
#spr2 "./alchera/2103_2.tga"
#descr "Maohi priest of Tane, spirit of birds and trees.  Tohungas serve many roles in the community, and wield the Tiki Wananga or 'Godstick' of patron spirit.  Tane is the patron spirit of wild birds and beasts."
#ap 8
#mapmove 2
#hp 12
#size 2
#str 11
#enc 3
#att 10
#def 10
#prec 12
#mr 12
#mor 13
#gcost 130
#rcost 1
#weapon "Godstick"
#armor "Crown"
#armor "Leather Cuirass"
#maxage 55
#startage 40
#swampsurvival
#okleader
#holy
#magicskill 8 2
#magicskill 1 1
#magicskill 6 1
#custommagic 8192 50
#custommagic 256 25
#end

#newmonster 2485
#clear
#clearmagic
#name "Tawhirimatea Tohunga"
#nametype 126
#spr1 "./alchera/2104_1.tga"
#spr2 "./alchera/2104_2.tga"
#descr "Maohi priest of Tawhiri, spirit of storms.  Tohungas serve many roles in the community, and wield the Tiki Wananga or 'Godstick' of patron spirit.  Tawhiri is a wrathful spirit who has an ancient quarrel with his brothers, and his Tangaroas mostly beseech him to contain his anger."
#ap 8
#mapmove 2
#hp 12
#size 2
#str 11
#enc 3
#att 10
#def 10
#prec 11
#mr 12
#mor 13
#gcost 130
#rcost 1
#weapon "Godstick"
#armor "Crown"
#armor "Leather Cuirass"
#maxage 55
#startage 40
#swampsurvival
#okleader
#holy
#magicskill 8 2
#magicskill 1 2
#custommagic 512 50
#custommagic 256 25
#end

#newmonster 2486
#clear
#clearmagic
#name "Tumatauenga Tohunga"
#nametype 126
#spr1 "./alchera/2105_1.tga"
#spr2 "./alchera/2105_2.tga"
#descr "Maohi priest of Tu, the spirit of war.  Tohungas serve many roles in the community, and wield the Tiki Wananga or 'Godstick' of their patron spirit.  The presence of a Tumatauenga Tohunga in battle inspires Maohi and Alchera alike to fight twice as hard.  The Tohungas of Tu, alone of the Aotearoa Priests, have taken to wearing chain mail."
#ap 12
#mapmove 2
#hp 15
#size 2
#str 12
#enc 3
#att 13
#def 13
#prec 12
#mr 12
#mor 14
#gcost 130
#rcost 1
#weapon "Godstick"
#weapon "Woomera"
#weapon "Woomera Shield"
#armor "Crown"
#armor "Chain Mail Hauberk"
#maxage 55
#startage 40
#swampsurvival
#superiorleader
#holy
#magicskill 8 2
#standard 10
#end

#newmonster 2487
#clear
#clearmagic
#name "Tangaroa Tohunga"
#nametype 126
#spr1 "./alchera/2106_1.tga"
#spr2 "./alchera/2106_2.tga"
#descr "Maohi priest of Tangaroa, spirit of the sea and its creatures.  Tohungas serve many roles in the community, and wield the Tiki Wananga or 'Godstick' of patron spirit.  The Tohungas of Tangaroa can inhale salt water and become sharks, but their magic weakens in this form."
#ap 8
#mapmove 2
#hp 12
#size 2
#str 11
#enc 3
#att 10
#def 9
#prec 11
#mr 12
#mor 13
#gcost 130
#rcost 1
#weapon "Godstick"
#armor "Crown"
#armor "Leather Cuirass"
#maxage 55
#startage 40
#swampsurvival
#okleader
#holy
#amphibian
#watershape 2490
#magicskill 8 2
#magicskill 2 2
#custommagic 512 25
#custommagic 8192 25
#end

#newmonster 2488
#clear
#clearmagic
#name "Tohunga Ahurewa"
#nametype 126
#spr1 "./alchera/2106_1.tga"
#spr2 "./alchera/2106_2.tga"
#descr "Greatest of the Tohungas are the Tohunga Ahurewa.  They spend long hours training at Te Whare Wananga, and are the only ones who preserve the subtle magics of old Alchera.  They are charged with keeping the Whakapapa, the history, memory, and geneology of all Aotearoa.  It is through Whakapapa that the sacred tattoos, Te Moko, are created."
#ap 8
#mapmove 2
#hp 12
#size 2
#str 11
#enc 3
#att 10
#def 9
#prec 11
#mr 12
#mor 13
#gcost 300
#rcost 1
#weapon "Godstick"
#armor "Crown"
#armor "Leather Cuirass"
#maxage 55
#wastesurvival
#swampsurvival
#okleader
#holy
#magicskill 8 3
#magicskill 4 1
#custommagic 8960 100
#custommagic 8960 100
#custommagic 256 50
#custommagic 512 50
#custommagic 8192 50
#custommagic 2048 10
#end

#newmonster 2490
#clear
#clearmagic
#copystats 816
#clearspec
#name "Tangaroa Tohunga"
#spr1 "./alchera/2201_1.tga"
#spr2 "./alchera/2201_2.tga"
#nametype 126
#descr "Maohi priest of Tangaroa in shark form."
#okleader
#magicskill 2 2
#magicskill 8 1
#amphibian
#noitem
#regeneration 10
#landshape 2487
#end

#newmonster 2491
#clear
#name "Mimi"
#spr1 "./alchera/2301_1.tga"
#spr2 "./alchera/2301_2.tga"
#descr "Mimis are slender and graceful creatures with disproporionately large heads.  They weigh next to nothing, and can travel upon a breeze like dandelion seeds, but fear storms because a strong enough wind will break their delicate necks.  They love yams, but their second favorite food is human flesh."
#ap 18
#mapmove 3
#hp 5
#size 2
#str 15
#enc 3
#att 12
#def 14
#prot 0
#prec 10
#mr 14
#mor 10
#weapon 20
#end

#newmonster 2492
#clear
#name "Bunyip"
#spr1 "./alchera/2302_1.tga"
#spr2 "./alchera/2302_2.tga"
#descr "The bunyip is a pond and bog-dwelling creature, born out of fears of drowning, that lives half in the Dreamtime and half in the material world. As such, it is very hard to hit with normal weapons.  Bunyips are equally at home on land and in water, moving with a supernatural speed that belies their short legs.  The roar of a Bunyip is unnerving, and those unfortunate enough to be bitten by a bunyip contract a terrible fever that few survive."
#ap 20
#mapmove 2
#hp 24
#size 3
#str 20
#enc 3
#att 14
#def 16
#prot 9
#prec 8
#mr 15
#mor 12
#amphibian
#magicbeing
#ethereal
#weapon "Bunyip Bite"
#fear
#end

#newmonster 2493
#clear
#clearmagic
#name "Maero"
#spr1 "./alchera/2304_1.tga"
#spr2 "./alchera/2304_2.tga"
#descr "Maeros are lesser children of Tane, wild beastmen who hunt with their long claws and are prone to destructive rages.  They appear wherever the Maohi go, and have long been an irritation to them, but Tane will not allow them to be killed.  He does permit his priests to take charge of them and send them to war, but even thus compelled, the Maero are still unruly and cause unrest."
#ap 12
#mapmove 2
#hp 14
#size 2
#str 13
#enc 2
#att 12
#def 12
#prec 8
#prot 3
#mr 10
#mor 10
#weapon "Claws"
#regeneration 50
#immortal
#berserk 2
#incunrest 1
#end

#newmonster 2493
#clear
#name "Yarama Yha-who"
#spr1 "./alchera/2305_1.tga"
#spr2 "./alchera/2305_2.tga"
#descr "The Yarama Yha-who is a fearsome arboreal vampire that sucks blood from its victims through suckers on its limbs.  It's gaping jaws can stretch wide enough to swallow a man whole.  They are born in the Dreamtime of tales told to frighten children and can be drawn therefrom into the material world."
#ap 12
#mapmove 2
#hp 24
#size 4
#str 14
#enc 3
#att 14
#def 12
#prec 12
#prot 10
#mr 15
#mor 12
#weapon "Life Drain"
#weapon "Life Drain"
#weapon "Yarama Bite"
#forestsurvival
#ethereal
#magicbeing
#end

#newmonster 2494
#clear
#clearmagic
#copystats 816
#name "Taniwha"
#nametype 126
#spr1 "./alchera/2307_1.tga"
#spr2 "./alchera/2307_2.tga"
#descr "Taniwha are guardian spirits specific to certain bodies of water.  They take many forms, the most common of which is a spiny sharklike form.  They can draw and control mundane sharks, but rarely leave their home provinces."
#mapmove 0
#magicbeing
#okleader
#okmagicleader
#magicskill 2 3
#magicskill 512 33
#regeneration 10
#makemonster1 816
#poisonarmor
#noitem
#end

#newmonster 2495
#clear
#clearmagic
#copystats 816
#name "Tohunga Taniwha"
#nametype 126
#spr1 "./alchera/2307_1.tga"
#spr2 "./alchera/2307_2.tga"
#descr "Humans who become Taniwha can never return to land, but, unlike other Taniwha, are not bound to a specific body of water."
#mapmove 1
#magicbeing
#okleader
#okmagicleader
#magicskill 2 3
#magicskill 512 33
#regeneration 10
#makemonster1 816
#poisonarmor
#noitem
#end

#newmonster 2398
#clear
#clearmagic
#name "Kupe Toitehuatahi"
#nametype 126
#spr1 "./alchera/2401_1.tga"
#spr2 "./alchera/2401_2.tga"
#descr "Demititan ancestor of the Maohi people, who brought them all to Alchera in a great canoe when disaster befell their homeland.  The spirits Tanematahuta, Tawhirimatea, Tumatauenga, and Tangaroa, fearing their own destruction, begged shelter in his canoe, in exchange for which he learned mastry over the nature, sea, sky and man.  After a long absence, he has returned lead his people to glory."
#ap 14
#mapmove 2
#hp 60
#size 4
#str 18
#enc 3
#att 13
#def 13
#prec 12
#prot 7
#mr 16
#mor 30
#gcost 120
#weapon "Magic Spear"
#weapon "Patu"
#armor "Crown"
#armor "Leather Cuirass"
#maxage 1000
#swampsurvival
#superiorleader
#okmagicleader
#standard 14
#ambidextrous 3
#sailing
#magicskill 1 2
#magicskill 2 2
#magicskill 6 2
#pathcost 40
#startdom 1
#restrictedgod 73
#end

#newmonster 2399
#clear
#clearmagic
#name "Great Ancestor"
#nametype 126
#spr1 "./alchera/2402_1.tga"
#spr2 "./alchera/2402_2.tga"
#descr "The term 'Ancestor' is imprecise, as this pretender was born in the Dreamtime, and not even he knows when his parents were from: his mother died in childbirth and his father is unknown.  Nursed by Yowies and trained in the ways of the Dreamtime from birth, he is more, and some would say less, than human.  His appearance was prophesied and is cause for both celebration and fear."
#ap 18
#mapmove 3
#hp 24
#size 2
#str 12
#enc 3
#att 13
#def 14
#prec 12
#mr 18
#mor 18
#gcost 40
#weapon "Magic Spear"
#armor "Magic Shield"
#armor "Crown"
#armor "Possum-skin cloak"
#maxage 1000
#wastesurvival
#poorleader
#superiormagicleader
#ethereal
#stealthy 30
#assassin
#horrormark
#magicskill 4 2
#magicskill 1 1
#pathcost 10
#startdom 2
#restrictedgod 73
#end

#selectnametype 148
#clear
#addname "Maui"
#end

#newmonster 2401
#clear
#clearmagic
#name "Trickster Hero"
#nametype 147
#spr1 "./alchera/2404_1.tga"
#spr2 "./alchera/2404_2.tga"
#descr "Maui's exploits are legendary.  Cast into the sea at birth, he was saved from drowning by the Taniwha and raised by Rangi, the spirit of the sky. The jawbone of his grandfather is his talisman, and his feats include catching a fish the size of an island and stealing fire from and angry spirit.  A great hero, he is also a trickster and sometimes a glory hound.  When quick wits and quick reflexes aren't enough, he relies on his legendary luck, which seems to be contagious, inspiring those around him, but is unreliable, sometimes affecting others but not himself."
#ap 12
#mapmove 2
#hp 18
#size 2
#str 14
#enc 3
#att 14
#def 15
#prec 14
#mr 13
#mor 16
#gcost 150
#rcost 10
#weapon "Grandfather's Jawbone"
#weapon "Woomera"
#armor "Woomera Shield"
#armor "Circlet"
#armor "Leather Cuirass"
#maxage 100
#swampsurvival
#sailing
#goodleader
#holy
#onebattlespell "Battle Fortune"
#standard 20
#magicskill 0 2
#end

#newweapon 681
#name "War Boomerang"
#dmg 2
#att 1
#range -1
#ammo 1
#rcost 1
#enc 0
#sound 15
#flyspr 304 4
#flail
#dt_paralyze
#end

#newweapon 682
#name "Woomera"
#dmg 4
#att 0
#enc 1
#range 20
#ammo 2
#rcost 1
#sound 19
#flyspr 110 1
#end

#newweapon 683
#name "Patu"
#dmg 3
#att 1
#def 1
#len 1
#rcost 2
#end

#newweapon 684
#name "Godstick"
#dmg 3
#att 1
#def 2
#len 4
#rcost 7
#magic
#end

#newweapon 685
#name "Bunyip Bite"
#dmg 2
#att 0
#def -1
#len 0
#secondaryeffect 414
#end

#newweapon 686
#name "Yarama Bite"
#dmg 2
#att 0
#def -1
#len 0
#dt_small
#nratt -2
#end

#newweapon 687
#name "Grandfather's Jawbone"
#dmg 7
#att 4
#def 3
#len 2
#rcost 1
#magic
#end

#newarmor 281
#name "Possum-skin Cloak"
#type 5
#prot 9
#def -1
#enc 2
#rcost 6
#end

#newarmor 282
#name "Sharkstooth Necklace"
#type 6
#prot 0
#def 2
#enc 0
#rcost 1
#end

#newarmor 283
#name "Woomera Shield"
#type 4
#def 2
#prot 14
#enc 1
#rcost 1
#end

#newspell
#name "Call Mimis"
#descr "With a low, ululating song, the caster calls the Mimis out from their hiding places, and they come from all directions, hungry for flesh.  Skilled singers can draw Mimis from miles away."
#school 4
#researchlevel 4
#path 0 1
#pathlevel 0 2
#effect 43
#nreff 1004
#damage 2301
#fatiguecost 200
#restricted 73
#end

#newspell
#name "Summon Bunyip"
#descr "Calls forth a Bunyip from a deep well and magically yokes it to the caster."
#school 0
#researchlevel 3
#path 0 4
#pathlevel 0 2
#effect 10001
#nreff 1
#damage 2302
#fatiguecost 200
#restricted 73
#end

#newspell
#name "Compell Maeros"
#descr "The Tohunga goes to a Maero campsite, and, with Tane's blessing, binds a few to his purpose."
#school 4
#researchlevel 2
#path 0 6
#pathlevel 0 1
#path 1 8
#pathlevel 1 1
#effect 10001
#nreff 1
#damage 2304
#fatiguecost 200
#restricted 73
#end

#newspell
#name "Summon Yarama Ya-Who"
#descr "This spell calls a few of the Yarma Ya-Who out of the Dreamtime.  These evil spirits suck the blood from their victims and swallow smaller prey whole."
#school 0
#researchlevel 5
#path 0 4
#pathlevel 0 5
#effect 10001
#nreff 1000
#damage 2395
#fatiguecost 1500
#restricted 73
#end


#newspell
#name "Tangaroa's Brood"
#descr "The mage-priest's prayers attract an ocean guardian, a Taniwha.  The Taniwha are children of Tangaroa and guardians of specific lakes and oceans.  They can survive out of water but never willingly leave their home.  This spell can only be cast underwater."
#school 4
#researchlevel 5
#path 0 2
#pathlevel 0 1
#path 1 8
#pathlevel 1 1
#effect 10021
#nreff 1
#damage 2494
#spec 41943040
#fatiguecost 1200
#restricted 73
#end

#newspell
#name "Child of the Sea"
#descr "Sometimes, those favored by Tangaroa become Taniwha after death.  A sufficiently fervant or desparate Tohunga may beseech Tangaroa to grant him this boon.  Humans who become Taniwha are not bound to one place the way that other Taniwha are."
#school 4
#researchlevel 6
#path 0 2
#pathlevel 0 1
#path 1 8
#pathlevel 1 1
#effect 10021
#nreff 1
#damage 2495
#spec 41943040
#fatiguecost 300
#nextspell 91
#restricted 73
#end

#newspell
#copyspell 296
#name "Tawhiri 2"
#school -1
#path -1
#nextspell 91
#restricted 73
#end

#newspell
#copyspell 288
#name "Wrath of Tawhiri"
#descr "The Tohungas of Tawhiri spend most of their time placating Tawhiri, an angry storm spirit with little love for his brothers or humankind.  This feared ritual undoes much of that work, unloosing Tawhiri's full fury on the battlefield.  The resulting lighning storm is a danger to friend and foe alike.  The Tohungas use this spell only as a last resort, as the first life Tawhiri takes is invariably that of the caster."
#school 2
#researchlevel 5
#path 0 1
#pathlevel 0 2
#path 1 8
#pathlevel 1 1
#fatiguecost 400
#nextspell "Tawhiri 2"
#restricted 73
#end

#newspell
#copyspell "Anathema"
#name "Whakanoa"
#descr "The rituals that render the sacred (tapu) into the mundane (noa) can be used against the priests and holy warriors of other Pretenders.  The Tohungas do not possess the power to sever heretics from their God, but they can curse them, bringing misfortune upon them."
#school 1
#researchlevel 0
#path 0 8
#pathlevel 0 2
#fatiguecost 0
#restricted 73
#end

#newspell
#name "Walkabout"
#descr "The caster slips into the dreamtime steps out in another part of the world."
#school 5
#researchlevel 0
#path 0 4
#pathlevel 0 2
#effect 10019
#nreff 1
#fatiguecost 100
#restricted 73
#end

#newspell
#name "Follow Songlines"
#descr "The caster leads his army into the Dreamtime and follows the songlines home."
#school 5
#researchlevel 0
#path 0 4
#pathlevel 0 2
#effect 10015
#nreff 1
#fatiguecost 700
#restricted 73
#end

#newsite 881
#name "Forest of Tanematahuta"
#level 0
#rarity 5
#loc 16348
#gems 6 2
#gems 1 1
#homemon 2475
#end

#newsite 882
#name "Tangaroa's Lagoon"
#level 0
#rarity 5
#loc 16348
#gems 2 1
#homemon 2476
#end

#newsite 883
#name "Te Whare Wananga"
#level 0
#rarity 5
#loc 16348
#gems 4 1
#homecom 2488
#end

#selectnation 73
#name "Aotearoa"
#epithet "Age of Whakapapa"
#era 2
#descr "The Alchera are one of the oldest human societies, though the term is nearly meaningless to them, as they live according to the ways of the Dreamtime, which touches on all times.  Recently, the Maohi have immigrated in large numbers, fleeing a catastrophe in their island home. The Maohi revere Tane, the spirit of forests and birds; Tawhiri, the spirit of storms; Tangaroa, the spirit of the sea; and Tu, the god of war.  The Alchera have no priests, but their dreamwalkers become etherial through contact with the Dreamtime, and dreamwalker commanders are powerful astral mages.  Neither the Alchera nor the Maohi wear heavy armor, and have neither archers nor cavalry of their own, but the Alchera are magic resistant and the Maohi are stronger and more resiliant than most people.  They have a number of national summons, ranging from the weak but immortal Maero beastmen to the mysterious Bunyip to the great Rainbow Serpents at the heart of the Dreamtime."
#summary "Inexpensive units and spellcasters, sacred etherial and stealthy units and commanders, some seafaring and underwater ability.  The Alchera have superior magic resistance, the Maohi superior health and strength.  No archers, cavalry or heavy armor.  Astral, air and water magic, some nature.  Weak priests with one average priest."
#brief "A nation of stealthy aboriginal people and seafaring tribal immigrants."
#color 0.1 0.3 0.7
#flag ".\alchera\flag.tga"
#templepic 16
#startcom 2486
#startscout 2480
#startunittype1 2470
#startunittype2 2471
#addrecunit 2469
#addrecunit 2470
#addrecunit 2471
#addrecunit 2472
#addrecunit 2473
#addrecunit 2474
#addrecunit 2475
#addreccom 2480
#addreccom 2481
#addreccom 2482
#addreccom 2483
#addreccom 2484
#addreccom 2485
#addreccom 2486
#addreccom 2487
#defcom1 2482
#defunit1 2469
#defmult1 20
#defunit1b 2470
#defmult1b 20
#defcom2 2486
#defunit2 2471
#defmult2 20
#defunit2b 2472
#defmult2b 20
#hero1 2470
#startsite "Forest of Tanematahuta"
#startsite "Tangaroa's Lagoon"
#startsite "Te Whare Wananga"
#startfort 22
#defaultfort 32
#swampfort 11
#forestfort 33
#mountainfort 36
#end