#!/usr/bin/env python
# -*- Mode: Python; tab-width: 4 -*-

import sys, random
from DMG import D3MNation, D3MSite


def pop_random(list):
    return list.pop(random.randrange(len(list)))
        

def get_magic_paths(number = 2):
    magic_paths = ["Fire",
                   "Air",
                   "Water",
                   "Earth",
                   "Astral",
                   "Nature",
                   "Death",
                   "Blood"]
    paths = []

    for path in range(number):
        paths.append(magic_paths.pop(random.randrange(len(magic_paths))))

    return paths

def get_tribes(number = 2):
    tribes = ["Asmeg",
              "Amazon",
              "Atavi",
              "Fir Bolg",
              "Hoburg",
              "Ichtyid",
              "Raptor",
              "Caveman",
              "Bakemono",
              "Barbarian",
              "Bear",
              "Deer",
              "Horse",
              "Jaguar",
              "Lion",
              "Toad",
              "Wolf",
              "Vaettir",
              "Shambler",
              "Elephant",
              "Troll",
              "Woodsmen",
              ]
    tribez = []

    for element in range(number):
        tribez.append(pop_random(tribes))

    return tribez

def get_epithet():
    choice1 = ["Beaten", "Sore", "Bleeding", "Wounded", "Maimed", "Hurt", "Blessed"]
    choice2 = ["Angry", "Vengeful", "Grumpy", "Furious", "Cross", "Pissed", "Joyful"]
    return pop_random(choice1) + " and " + pop_random(choice2)

def create_nation(mod, name, era = 1, flag = None):
    epithet = get_epithet()
    summary = ""
    summary += "Magic: "
    magic_paths = get_magic_paths(2)
    
    for path in magic_paths:
        summary += path + ", "
    summary = summary[:-2] 

    tribes = get_tribes(3)
    base_name = ''.join(tribes)
    name =  base_name + " Alliance"
    
    description = "Vanquished and exiled from their homeland by invading Pretender Gods, "
    description += "the " + name + " has settled here and is determined to survive."
        
    IndyFunPits = D3MNation(era, name, epithet, summary, description, summary, flag)
    FunPitPower = D3MSite(base_name)
    FunPitPower2 = D3MSite(base_name + " II")

    base_recruitables = []
    base_commanders = [240]
    capital_recruitables = []
    capital_commanders = []

    commander1 = 34  # regular commander
    commander2 = 240 # H1 priest
    army1 = 17 # archer
    army2 = 29 # javelin light infantry
    army3 = 38 # medium heavy infantry
    army4 = 39 # heavy infantry
    mult1 = 10 
    mult2 = 10 
    mult3 = 5 
    mult4 = 5 
    for tribe in tribes:
        if tribe == "Amazon":
            color = pop_random(["Crystal", "Garnet", "Jade", "Onyx"])
            if color == "Crystal":
                base_recruitables += [348]
                capital_recruitables += [367]
                base_commanders += [347]
                capital_commanders += [346]
                commander2 = 347
                army2 = 348
            if color == "Garnet":
                base_recruitables += [351]
                capital_recruitables += [612]
                base_commanders += [350]
                capital_commanders += [349]
                commander2 = 350
                army2 = 351
            if color == "Jade":
                base_recruitables += [354]
                capital_recruitables += [370]
                base_commanders += [353]
                capital_commanders += [352]
                commander2 = 353
                army2 = 354
            if color == "Onyx":
                base_recruitables += [357]
                capital_recruitables += [369]
                base_commanders += [356]
                capital_commanders += [355]
                commander2 = 356
                army2 = 357
        if tribe == "Atavi":
            base_recruitables += [1118,1121,1122]
            base_commanders += [1127]
            army1 = 1121
            army2 = 1122
            commander1 = 1127
        if tribe == "Fir Bolg":
            base_recruitables += [1749,1758,1756]
            base_commanders += [1750]
            commander1 = 1750
            army1 = 1758
            army2 = 1756
        if tribe == "Hoburg":
            if era == 3:
                base_recruitables += [271, 273, 483]
                army3 = 271
                army4 = 273
            elif era == 2:
                base_recruitables += [271, 483, 1196]
                army3 = 271
                army4 = 1196
            else:
                base_recruitables += [483]
                captial_recruitables = [271, 1196]
                army4 = 1196
            army1 = 483
            base_commanders += [272, 1195, 1198]
            commander1 = 272
            commander2 = 1195
        if tribe == "Ichtyid":
            base_recruitables += [974, 975]
            base_commanders += [976]
            commander1 = 976
            army1 = 974
            army3 = 975
        if tribe == "Human":
            if era == 3:
                base_recruitables += [47, 29, 39, 26]
                army4 = 47
            elif era == 2:
                base_recruitables += [55, 29, 38, 26]
                army4 = 55
            else:
                base_recruitables += [50, 17, 29, 26]
            base_commanders += [426, 240, 34, 44]
        if tribe == "Raptor":
            base_recruitables += [205]
            base_commanders += [252]
            commander2 = 252
            army3 = 205
        if tribe == "Caveman":
            base_recruitables += [1465, 1615]
            base_commanders += [1463, 1616]
            commander1 = 1463
            army3 = 1615
            mult3 = 3
        if tribe == "Bakemono":
            base_recruitables += [1394, 1395, 1260]
            base_commanders += [1845, 1609]
            army1 = 1395
            army2 = 1394
            mult2 = 20
            commander1 = 1845
        if tribe == "Barbarian":
            base_recruitables += [139,140]
            base_commanders += [141]
            army2 = 140
            mult2 = 15
        if tribe == "Asmeg":
            capital_commanders += [1002]
        if tribe == "Elephant":
            capital_recruitables += [150]
        if tribe == "Troll":
            capital_recruitables += [518]
        if tribe == "Bear":
            base_recruitables += [1592,1593]
            base_commanders += [1597]
            army1 = 1593
            army2 = 1592
            commander2 = 1597
        if tribe == "Woodsmen":
            base_recruitables += [125,126]
            base_commanders += [105]
            army1 = 125
            army2 = 126
            commander2 = 105
        if tribe == "Deer":
            base_recruitables += [1594,1595]
            base_commanders += [1598]
            army1 = 1595
            army2 = 1594
            commander2 = 1598
        if tribe == "Wolf":
            base_recruitables += [123,124]
            base_commanders += [1596]
            army1 = 123
            army2 = 124
            commander2 = 1596
        if tribe == "Horse":
            base_recruitables += [137]
            base_commanders += [136]
            commander1 = 136
            army3 = 137
        if tribe == "Jaguar":
            base_recruitables += [1610,1611]
            base_commanders += [1612]
            army1 = 1611
            commander2 = 1612
        if tribe == "Lion":
            base_recruitables += [1600,1601]
            base_commanders += [1602]
            army1 = 1601
            army2 = 1600
            commander2 = 1602
        if tribe == "Toad":
            base_recruitables += [1613]
            base_commanders += [1614]
            army2 = 1613
            commander2 = 1614
        if tribe == "Vaettir":
            base_recruitables += [541, 282]
            base_commanders += [913]
            army1 = 541
            mult1 = 15
            army3 = 282
            commander2 = 913
        if tribe == "Shambler":
            base_recruitables += [206]
            base_commanders += [207]
            army4 = 206
    IndyFunPits.add_units(base_recruitables)
    IndyFunPits.add_commanders(base_commanders)
    FunPitPower2.add_units(capital_recruitables)
    FunPitPower2.add_commanders(capital_commanders)

    IndyFunPits.set_PD(commander1,
                       commander2,
                       army1,
                       army2,
                       army3,
                       army4,
                       mult1,
                       mult2,
                       mult3,
                       mult4)    

    IndyFunPits.set_startarmy(commander1,
                              commander2,
                              army1,
                              20,
                              army2,
                              20)

    for path in magic_paths:
        if path == "Fire":
            FunPitPower.add_commanders(99)
            FunPitPower.add_gems(0,1)
        if path == "Air":
            FunPitPower.add_commanders(341)
            FunPitPower.add_gems(1,1)
        if path == "Water":
            FunPitPower.add_commanders(97)
            FunPitPower.add_gems(2,1)
        if path == "Earth":
            FunPitPower.add_commanders(325)
            FunPitPower.add_gems(3,1)
        if path == "Astral":
            FunPitPower.add_commanders(1933)
            FunPitPower.add_gems(4,1)
        if path == "Death":
            FunPitPower.add_commanders(310)
            FunPitPower.add_gems(5,1)
        if path == "Nature":
            FunPitPower.add_commanders(552)
            FunPitPower.add_gems(6,1)
        if path == "Blood":
            FunPitPower.add_commanders(122)
            FunPitPower.add_gems(7,1)
 
    IndyFunPits.add_site(FunPitPower.name)
    IndyFunPits.add_site(FunPitPower2.name)
    IndyFunPits.set_forts(castleprod = 0,
                          startfort = 3,
                          defaultfort = 8,
                          farmfort = 3,
                          forestfort = 33,
                          mountainfort = 36,
                          swampfort = 10)
    mod.add_nation(IndyFunPits)
    mod.add_site(FunPitPower)
    mod.add_site(FunPitPower2)
